/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.query.SortOrder;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class FunctionExpression
implements OrderingExpression,
FunctionRenderingSupport {
    private final String name;
    private final List<OrderingExpression> arguments;

    public FunctionExpression(String name, int numberOfArguments) {
        this.name = name;
        this.arguments = numberOfArguments == 0 ? Collections.emptyList() : new ArrayList(numberOfArguments);
    }

    public String getName() {
        return this.name;
    }

    public List<OrderingExpression> getArguments() {
        return this.arguments;
    }

    public void addArgument(OrderingExpression argument) {
        this.arguments.add(argument);
    }

    @Override
    public SelfRenderingFunctionSqlAstExpression resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        int size = this.arguments.size();
        ArrayList<SqlAstNode> args = new ArrayList<SqlAstNode>(size);
        for (int i = 0; i < size; ++i) {
            String subModelPartName;
            OrderingExpression orderingExpression = this.arguments.get(i);
            if (orderingExpression instanceof DomainPath) {
                String partName = ((DomainPath)orderingExpression).getNavigablePath().getUnaliasedLocalName();
                subModelPartName = CollectionPart.Nature.ELEMENT.getName().equals(partName) ? "$element$" : partName;
            } else {
                subModelPartName = null;
            }
            args.add(orderingExpression.resolve(ast, tableGroup, subModelPartName, creationState));
        }
        return new SelfRenderingFunctionSqlAstExpression(this.name, this, args, null, tableGroup.getModelPart().findSubPart(modelPartName, null));
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, SqlAstCreationState creationState) {
        SelfRenderingFunctionSqlAstExpression expression = this.resolve(ast, tableGroup, modelPartName, creationState);
        ast.addSortSpecification(new SortSpecification(expression, collation, sortOrder));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(this.name);
        sqlAppender.appendSql('(');
        if (!sqlAstArguments.isEmpty()) {
            sqlAstArguments.get(0).accept(walker);
            for (int i = 1; i < sqlAstArguments.size(); ++i) {
                sqlAppender.appendSql(", ");
                sqlAstArguments.get(i).accept(walker);
            }
        }
        sqlAppender.appendSql(')');
    }
}

