/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;

public class NamedEnumValueConverter<E extends Enum<E>>
implements EnumValueConverter<E, String>,
Serializable {
    private final EnumJavaTypeDescriptor<E> domainTypeDescriptor;
    private final JdbcTypeDescriptor jdbcTypeDescriptor;
    private final JavaTypeDescriptor<String> relationalTypeDescriptor;
    private transient ValueExtractor<String> valueExtractor;
    private transient ValueBinder<String> valueBinder;

    public NamedEnumValueConverter(EnumJavaTypeDescriptor<E> domainTypeDescriptor, JdbcTypeDescriptor jdbcTypeDescriptor, JavaTypeDescriptor<String> relationalTypeDescriptor) {
        this.domainTypeDescriptor = domainTypeDescriptor;
        this.jdbcTypeDescriptor = jdbcTypeDescriptor;
        this.relationalTypeDescriptor = relationalTypeDescriptor;
        this.valueExtractor = jdbcTypeDescriptor.getExtractor(relationalTypeDescriptor);
        this.valueBinder = jdbcTypeDescriptor.getBinder(relationalTypeDescriptor);
    }

    @Override
    public EnumJavaTypeDescriptor<E> getDomainJavaDescriptor() {
        return this.domainTypeDescriptor;
    }

    @Override
    public JavaTypeDescriptor<String> getRelationalJavaDescriptor() {
        return this.relationalTypeDescriptor;
    }

    @Override
    public E toDomainValue(String relationalForm) {
        return this.domainTypeDescriptor.fromName(relationalForm);
    }

    @Override
    public String toRelationalValue(E domainForm) {
        return this.domainTypeDescriptor.toName(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeDescriptor.getJdbcTypeCode();
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((Enum)value).name());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = this.jdbcTypeDescriptor.getExtractor(this.relationalTypeDescriptor);
        this.valueBinder = this.jdbcTypeDescriptor.getBinder(this.relationalTypeDescriptor);
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        String jdbcValue = value == null ? null : ((Enum)value).name();
        this.valueBinder.bind(statement, jdbcValue, position, (WrapperOptions)session);
    }
}

