/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.Serializable;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractPluralAttribute<D, C, E>
extends AbstractAttribute<D, C, E>
implements PluralPersistentAttribute<D, C, E>,
Serializable {
    private final CollectionClassification classification;
    private final SqmPathSource<E> elementPathSource;

    protected AbstractPluralAttribute(PluralAttributeBuilder<D, C, E, ?> builder, MetadataContext metadataContext) {
        super(builder.getDeclaringType(), builder.getProperty().getName(), builder.getCollectionJavaTypeDescriptor(), builder.getAttributeClassification(), builder.getValueType(), builder.getMember(), metadataContext);
        this.classification = builder.getCollectionClassification();
        this.elementPathSource = SqmMappingModelHelper.resolveSqmPathSource(CollectionPart.Nature.ELEMENT.getName(), builder.getValueType(), Bindable.BindableType.PLURAL_ATTRIBUTE);
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return this.classification;
    }

    @Override
    public SqmPathSource<E> getElementPathSource() {
        return this.elementPathSource;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.elementPathSource.findSubPathSource(name);
    }

    public PluralAttribute.CollectionType getCollectionType() {
        return this.getCollectionClassification().toJpaClassification();
    }

    @Override
    public JavaTypeDescriptor<E> getExpressableJavaTypeDescriptor() {
        return this.getElementType().getExpressableJavaTypeDescriptor();
    }

    @Override
    public SimpleDomainType<E> getElementType() {
        return this.getValueGraphType();
    }

    @Override
    public SimpleDomainType<E> getValueGraphType() {
        return super.getValueGraphType();
    }

    @Override
    public SimpleDomainType getKeyGraphType() {
        return null;
    }

    public boolean isAssociation() {
        return this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY;
    }

    public boolean isCollection() {
        return true;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public Class<E> getBindableJavaType() {
        return this.getElementType().getJavaType();
    }

    @Override
    public SqmPath<E> createSqmPath(SqmPath<?> lhs) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getPathName());
        return new SqmPluralValuedSimplePath(navigablePath, this, (SqmPath)lhs, lhs.nodeBuilder());
    }
}

