/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.metamodel.model.domain.AllowableOutputParameterType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.ParameterMisuseException;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.result.Output;
import org.hibernate.result.internal.OutputsImpl;
import org.hibernate.sql.exec.ExecutionException;

public class ProcedureOutputsImpl
extends OutputsImpl
implements ProcedureOutputs {
    private final ProcedureCallImpl procedureCall;
    private final CallableStatement callableStatement;
    private final ProcedureParameterImplementor[] refCursorParameters;
    private int refCursorParamIndex;

    ProcedureOutputsImpl(ProcedureCallImpl procedureCall, CallableStatement callableStatement) {
        super(procedureCall, callableStatement);
        this.procedureCall = procedureCall;
        this.callableStatement = callableStatement;
        this.refCursorParameters = procedureCall.collectRefCursorParameters();
    }

    @Override
    public <T> T getOutputParameterValue(ProcedureParameter<T> parameter) {
        AllowableParameterType hibernateType = parameter.getHibernateType();
        if (hibernateType instanceof AllowableOutputParameterType) {
            try {
                return (T)((AllowableOutputParameterType)hibernateType).extract(this.callableStatement, parameter.getPosition(), this.procedureCall.getSession());
            }
            catch (SQLException e) {
                throw new ExecutionException("Error extracting procedure output parameter value [" + parameter + "]", e);
            }
        }
        throw new ParameterMisuseException("Parameter type cannot extract procedure output parameters");
    }

    @Override
    public Object getOutputParameterValue(String name) {
        return this.getOutputParameterValue((ProcedureParameter)((Object)this.procedureCall.getParameterMetadata().getQueryParameter(name)));
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this.getOutputParameterValue((ProcedureParameter)((Object)this.procedureCall.getParameterMetadata().getQueryParameter(position)));
    }

    @Override
    protected OutputsImpl.CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount) {
        return new ProcedureCurrentReturnState(isResultSet, updateCount, this.refCursorParamIndex);
    }

    protected class ProcedureCurrentReturnState
    extends OutputsImpl.CurrentReturnState {
        private final int refCursorParamIndex;

        private ProcedureCurrentReturnState(boolean isResultSet, int updateCount, int refCursorParamIndex) {
            super(ProcedureOutputsImpl.this, isResultSet, updateCount);
            this.refCursorParamIndex = refCursorParamIndex;
        }

        @Override
        public boolean indicatesMoreOutputs() {
            return super.indicatesMoreOutputs() || ProcedureOutputsImpl.this.refCursorParamIndex < ProcedureOutputsImpl.this.refCursorParameters.length;
        }

        @Override
        protected boolean hasExtendedReturns() {
            return this.refCursorParamIndex < ProcedureOutputsImpl.this.refCursorParameters.length;
        }

        @Override
        protected Output buildExtendedReturn() {
            ProcedureOutputsImpl.this.refCursorParamIndex++;
            ProcedureParameterImplementor refCursorParam = ProcedureOutputsImpl.this.refCursorParameters[this.refCursorParamIndex];
            ResultSet resultSet = refCursorParam.getName() != null ? ProcedureOutputsImpl.this.procedureCall.getSession().getFactory().getServiceRegistry().getService(RefCursorSupport.class).getResultSet(ProcedureOutputsImpl.this.callableStatement, refCursorParam.getName()) : ProcedureOutputsImpl.this.procedureCall.getSession().getFactory().getServiceRegistry().getService(RefCursorSupport.class).getResultSet(ProcedureOutputsImpl.this.callableStatement, refCursorParam.getPosition());
            return this.buildResultSetOutput(() -> ProcedureOutputsImpl.this.extractResults(resultSet));
        }
    }
}

