/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class QuerySplitter {
    public static <R> SqmSelectStatement<R>[] split(SqmSelectStatement<R> statement, SessionFactoryImplementor sessionFactory) {
        SqmRoot<?> unmappedPolymorphicReference = QuerySplitter.findUnmappedPolymorphicReference(statement.getQueryPart());
        if (unmappedPolymorphicReference == null) {
            return new SqmSelectStatement[]{statement};
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedPathSource();
        SqmSelectStatement[] expanded = new SqmSelectStatement[unmappedPolymorphicDescriptor.getImplementors().size()];
        int i = -1;
        for (EntityDomainType<?> mappedDescriptor : unmappedPolymorphicDescriptor.getImplementors()) {
            UnmappedPolymorphismReplacer replacer = new UnmappedPolymorphismReplacer(unmappedPolymorphicReference, mappedDescriptor, sessionFactory);
            expanded[++i] = replacer.visitSelectStatement((SqmSelectStatement)statement);
        }
        return expanded;
    }

    private static SqmRoot<?> findUnmappedPolymorphicReference(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).getRoots().stream().filter(sqmRoot -> sqmRoot.getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor).findFirst().orElse(null);
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        SqmRoot<?> root = QuerySplitter.findUnmappedPolymorphicReference(queryGroup.getQueryParts().get(0));
        if (root != null) {
            throw new UnsupportedOperationException("Polymorphic query group is unsupported!");
        }
        return null;
    }

    private static class UnmappedPolymorphismReplacer<R>
    extends BaseSemanticQueryWalker
    implements SqmCreationState {
        private final SqmRoot unmappedPolymorphicFromElement;
        private final EntityDomainType mappedDescriptor;
        private final SqmCreationContext creationContext;
        private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
        private Map<NavigablePath, SqmPath> sqmPathCopyMap = new HashMap<NavigablePath, SqmPath>();
        private Map<SqmFrom, SqmFrom> sqmFromCopyMap = new HashMap<SqmFrom, SqmFrom>();
        private SqmFromClause currentFromClauseCopy = null;

        private UnmappedPolymorphismReplacer(SqmRoot unmappedPolymorphicFromElement, EntityDomainType mappedDescriptor, SessionFactoryImplementor sessionFactory) {
            super(sessionFactory.getServiceRegistry());
            this.unmappedPolymorphicFromElement = unmappedPolymorphicFromElement;
            this.mappedDescriptor = mappedDescriptor;
            this.creationContext = sessionFactory;
        }

        @Override
        public SqmInsertSelectStatement<R> visitInsertSelectStatement(SqmInsertSelectStatement<?> statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmUpdateStatement<R> visitUpdateStatement(SqmUpdateStatement<?> statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmSetClause visitSetClause(SqmSetClause setClause) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmAssignment visitAssignment(SqmAssignment assignment) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmDeleteStatement<R> visitDeleteStatement(SqmDeleteStatement<?> statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmSelectStatement<R> visitSelectStatement(SqmSelectStatement<?> statement) {
            SqmSelectStatement copy = new SqmSelectStatement(statement.nodeBuilder());
            this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), copy, this));
            try {
                copy.setQueryPart(this.visitQueryPart((SqmQueryPart)statement.getQueryPart()));
            }
            finally {
                this.processingStateStack.pop();
            }
            return copy;
        }

        @Override
        public SqmQueryPart<R> visitQueryPart(SqmQueryPart<?> queryPart) {
            return (SqmQueryPart)super.visitQueryPart(queryPart);
        }

        @Override
        public SqmQueryGroup<R> visitQueryGroup(SqmQueryGroup<?> queryGroup) {
            List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
            int size = queryParts.size();
            ArrayList newQueryParts = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                newQueryParts.add(this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            return new SqmQueryGroup(queryGroup.nodeBuilder(), queryGroup.getSetOperator(), newQueryParts);
        }

        @Override
        public SqmQuerySpec<R> visitQuerySpec(SqmQuerySpec<?> querySpec) {
            SqmQuerySpec sqmQuerySpec = new SqmQuerySpec(querySpec.nodeBuilder());
            sqmQuerySpec.setFromClause(this.visitFromClause(querySpec.getFromClause()));
            sqmQuerySpec.setSelectClause(this.visitSelectClause(querySpec.getSelectClause()));
            sqmQuerySpec.setWhereClause(this.visitWhereClause(querySpec.getWhereClause()));
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause((List)querySpec.getGroupByClauseExpressions()));
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause(querySpec.getHavingClausePredicate()));
            sqmQuerySpec.setOrderByClause(this.visitOrderByClause(querySpec.getOrderByClause()));
            if (querySpec.getFetchExpression() != null) {
                sqmQuerySpec.setFetchExpression((SqmExpression)querySpec.getFetchExpression().accept(this), querySpec.getFetchClauseType());
            }
            if (querySpec.getOffsetExpression() != null) {
                sqmQuerySpec.setOffsetExpression((SqmExpression)querySpec.getOffsetExpression().accept(this));
            }
            return sqmQuerySpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqmFromClause visitFromClause(SqmFromClause fromClause) {
            SqmFromClause previousCurrent = this.currentFromClauseCopy;
            try {
                SqmFromClause copy;
                this.currentFromClauseCopy = copy = new SqmFromClause(fromClause.getNumberOfRoots());
                super.visitFromClause(fromClause);
                SqmFromClause sqmFromClause = copy;
                return sqmFromClause;
            }
            finally {
                this.currentFromClauseCopy = previousCurrent;
            }
        }

        @Override
        public List<SqmExpression<?>> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
            if (groupByClauseExpressions.isEmpty()) {
                return groupByClauseExpressions;
            }
            ArrayList expressions = new ArrayList(groupByClauseExpressions.size());
            for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                expressions.add((SqmExpression)groupByClauseExpression.accept(this));
            }
            return expressions;
        }

        @Override
        public SqmPredicate visitHavingClause(SqmPredicate sqmPredicate) {
            if (sqmPredicate == null) {
                return null;
            }
            return (SqmPredicate)sqmPredicate.accept(this);
        }

        @Override
        public SqmRoot<?> visitRootPath(SqmRoot<?> sqmRoot) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(sqmRoot);
            if (sqmFrom != null) {
                return (SqmRoot)sqmFrom;
            }
            SqmPathSource pathSource = sqmRoot == this.unmappedPolymorphicFromElement ? this.mappedDescriptor : sqmRoot.getReferencedPathSource();
            SqmRoot copy = new SqmRoot(pathSource, sqmRoot.getExplicitAlias(), sqmRoot.nodeBuilder());
            return (SqmRoot)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(copy.getNavigablePath(), navigablePath -> {
                this.sqmFromCopyMap.put(sqmRoot, copy);
                this.sqmPathCopyMap.put(sqmRoot.getNavigablePath(), copy);
                this.currentFromClauseCopy.addRoot(copy);
                return copy;
            });
        }

        @Override
        public SqmCrossJoin<?> visitCrossJoin(SqmCrossJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCrossJoin)sqmFrom;
            }
            return (SqmCrossJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmRoot sqmRoot = (SqmRoot)this.sqmFromCopyMap.get(join.findRoot());
                SqmCrossJoin copy = new SqmCrossJoin(join.getReferencedPathSource(), join.getExplicitAlias(), sqmRoot);
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                sqmRoot.addSqmJoin(copy);
                return copy;
            });
        }

        @Override
        public SqmEntityJoin<?> visitQualifiedEntityJoin(SqmEntityJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmEntityJoin)sqmFrom;
            }
            return (SqmEntityJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmRoot sqmRoot = (SqmRoot)this.sqmFromCopyMap.get(join.findRoot());
                SqmEntityJoin copy = new SqmEntityJoin(join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), sqmRoot);
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                sqmRoot.addSqmJoin(copy);
                return copy;
            });
        }

        @Override
        public SqmAttributeJoin<?, ?> visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmAttributeJoin)sqmFrom;
            }
            return (SqmAttributeJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmAttributeJoin copy = join.makeCopy(this.getProcessingStateStack().getCurrent());
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                ((SqmFrom)copy.getParent()).addSqmJoin(copy);
                return copy;
            });
        }

        @Override
        public SqmBasicValuedSimplePath<?> visitBasicValuedPath(SqmBasicValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmBasicValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmBasicValuedSimplePath copy = new SqmBasicValuedSimplePath((NavigablePath)navigablePath, path.getReferencedPathSource(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()), path.nodeBuilder());
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmEmbeddedValuedSimplePath<?> visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmEmbeddedValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmEmbeddedValuedSimplePath copy = new SqmEmbeddedValuedSimplePath((NavigablePath)navigablePath, path.getReferencedPathSource(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()), path.nodeBuilder());
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmEntityValuedSimplePath<?> visitEntityValuedPath(SqmEntityValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmEntityValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmEntityValuedSimplePath copy = new SqmEntityValuedSimplePath((NavigablePath)navigablePath, path.getReferencedPathSource(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()), path.nodeBuilder());
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmPluralValuedSimplePath<?> visitPluralValuedPath(SqmPluralValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmPluralValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmPluralValuedSimplePath copy = new SqmPluralValuedSimplePath((NavigablePath)navigablePath, (PluralPersistentAttribute)path.getReferencedPathSource(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()), path.nodeBuilder());
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmSelectClause visitSelectClause(SqmSelectClause selectClause) {
            SqmSelectClause copy = new SqmSelectClause(selectClause.isDistinct(), selectClause.nodeBuilder());
            for (SqmSelection selection : selectClause.getSelections()) {
                copy.addSelection(new SqmSelection((SqmExpression)selection.getSelectableNode().accept(this), selection.getAlias(), selectClause.nodeBuilder()));
            }
            return copy;
        }

        @Override
        public SqmDynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> original) {
            SqmDynamicInstantiation copy;
            SqmDynamicInstantiationTarget<?> instantiationTarget = original.getInstantiationTarget();
            switch (instantiationTarget.getNature()) {
                case MAP: {
                    copy = SqmDynamicInstantiation.forMapInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                    break;
                }
                case LIST: {
                    copy = SqmDynamicInstantiation.forListInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                    break;
                }
                default: {
                    copy = SqmDynamicInstantiation.forClassInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                }
            }
            for (SqmDynamicInstantiationArgument<?> originalArgument : original.getArguments()) {
                copy.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)originalArgument.getSelectableNode().accept(this), originalArgument.getAlias(), this.getCreationContext().getNodeBuilder()));
            }
            return copy;
        }

        @Override
        public SqmWhereClause visitWhereClause(SqmWhereClause whereClause) {
            if (whereClause == null || whereClause.getPredicate() == null) {
                return null;
            }
            return new SqmWhereClause((SqmPredicate)whereClause.getPredicate().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmGroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
            return new SqmGroupedPredicate((SqmPredicate)predicate.accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmAndPredicate visitAndPredicate(SqmAndPredicate predicate) {
            return new SqmAndPredicate((SqmPredicate)predicate.getLeftHandPredicate().accept(this), (SqmPredicate)predicate.getRightHandPredicate().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmOrPredicate visitOrPredicate(SqmOrPredicate predicate) {
            return new SqmOrPredicate((SqmPredicate)predicate.getLeftHandPredicate().accept(this), (SqmPredicate)predicate.getRightHandPredicate().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
            return new SqmComparisonPredicate((SqmExpression)predicate.getLeftHandExpression().accept(this), predicate.getSqmOperator(), (SqmExpression)predicate.getRightHandExpression().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmEmptinessPredicate visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
            return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)predicate.getPluralPath().accept(this), predicate.isNegated(), predicate.nodeBuilder());
        }

        @Override
        public SqmNullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
            return new SqmNullnessPredicate((SqmExpression)predicate.getExpression().accept(this), predicate.isNegated(), predicate.nodeBuilder());
        }

        @Override
        public SqmBetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
            return new SqmBetweenPredicate((SqmExpression)predicate.getExpression().accept(this), (SqmExpression)predicate.getLowerBound().accept(this), (SqmExpression)predicate.getUpperBound().accept(this), predicate.isNegated(), predicate.nodeBuilder());
        }

        @Override
        public SqmLikePredicate visitLikePredicate(SqmLikePredicate predicate) {
            return new SqmLikePredicate((SqmExpression)predicate.getMatchExpression().accept(this), (SqmExpression)predicate.getPattern().accept(this), (SqmExpression)predicate.getEscapeCharacter().accept(this), predicate.nodeBuilder());
        }

        @Override
        public SqmMemberOfPredicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
            SqmPath pathCopy = this.sqmPathCopyMap.get(predicate.getPluralPath().getNavigablePath());
            return new SqmMemberOfPredicate(predicate.getLeftHandExpression(), pathCopy, predicate.nodeBuilder());
        }

        @Override
        public SqmNegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
            return new SqmNegatedPredicate((SqmPredicate)predicate.getWrappedPredicate().accept(this), predicate.nodeBuilder());
        }

        @Override
        public SqmInSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
            return new SqmInSubQueryPredicate((SqmExpression)predicate.getTestExpression().accept(this), this.visitSubQueryExpression(predicate.getSubQueryExpression()), predicate.nodeBuilder());
        }

        @Override
        public SqmOrderByClause visitOrderByClause(SqmOrderByClause orderByClause) {
            if (orderByClause == null || orderByClause.getSortSpecifications().isEmpty()) {
                return null;
            }
            SqmOrderByClause copy = new SqmOrderByClause();
            for (SqmSortSpecification sortSpecification : orderByClause.getSortSpecifications()) {
                copy.addSortSpecification(this.visitSortSpecification(sortSpecification));
            }
            return copy;
        }

        @Override
        public SqmSortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
            return new SqmSortSpecification((SqmExpression)sortSpecification.getSortExpression().accept(this), sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence());
        }

        @Override
        public SqmPositionalParameter visitPositionalParameterExpression(SqmPositionalParameter expression) {
            return new SqmPositionalParameter(expression.getPosition(), expression.allowMultiValuedBinding(), expression.nodeBuilder());
        }

        @Override
        public SqmNamedParameter visitNamedParameterExpression(SqmNamedParameter expression) {
            return new SqmNamedParameter(expression.getName(), expression.allowMultiValuedBinding(), expression.nodeBuilder());
        }

        @Override
        public SqmLiteralEntityType visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
            return new SqmLiteralEntityType(expression.getNodeType(), expression.nodeBuilder());
        }

        @Override
        public SqmUnaryOperation visitUnaryOperationExpression(SqmUnaryOperation expression) {
            return new SqmUnaryOperation(expression.getOperation(), (SqmExpression)expression.getOperand().accept(this));
        }

        @Override
        public SqmLiteral visitLiteral(SqmLiteral<?> literal) {
            return new SqmLiteral(literal.getLiteralValue(), literal.getNodeType(), literal.nodeBuilder());
        }

        @Override
        public SqmBinaryArithmetic visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
            return new SqmBinaryArithmetic(expression.getOperator(), (SqmExpression)expression.getLeftHandOperand().accept(this), (SqmExpression)expression.getRightHandOperand().accept(this), expression.getNodeType(), expression.nodeBuilder());
        }

        @Override
        public SqmSubQuery visitSubQueryExpression(SqmSubQuery expression) {
            return new SqmSubQuery(this.getProcessingStateStack().getCurrent().getProcessingQuery(), this.visitQueryPart((SqmQueryPart)expression.getQueryPart()), expression.getResultType(), expression.nodeBuilder());
        }

        @Override
        public Stack<SqmCreationProcessingState> getProcessingStateStack() {
            return this.processingStateStack;
        }

        @Override
        public SqmCreationContext getCreationContext() {
            return this.creationContext;
        }

        @Override
        public SqmCreationOptions getCreationOptions() {
            return () -> false;
        }
    }
}

