/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Consumer;
import javax.persistence.ColumnResult;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ResultMementoBasic;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValuedStandard;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class ResultMementoBasicStandard
implements ResultMementoBasic {
    public final String explicitColumnName;
    private final BasicType<?> explicitType;
    private final JavaTypeDescriptor<?> explicitJavaTypeDescriptor;

    public ResultMementoBasicStandard(ColumnResult definition, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = definition.name();
        BasicType resolvedBasicType = null;
        Class definedType = definition.type();
        if (Void.TYPE == definedType) {
            this.explicitJavaTypeDescriptor = null;
        } else {
            SessionFactoryImplementor sessionFactory = context.getSessionFactory();
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            BasicType registeredBasicType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(definition.type().getName());
            if (registeredBasicType != null) {
                this.explicitJavaTypeDescriptor = registeredBasicType.getJavaTypeDescriptor();
            } else {
                JavaTypeDescriptorRegistry jtdRegistry = typeConfiguration.getJavaTypeDescriptorRegistry();
                JavaTypeDescriptor registeredJtd = jtdRegistry.getDescriptor(definition.type());
                ManagedBeanRegistry beanRegistry = sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class);
                if (BasicType.class.isAssignableFrom(registeredJtd.getJavaTypeClass())) {
                    ManagedBean typeBean = beanRegistry.getBean(registeredJtd.getJavaTypeClass());
                    resolvedBasicType = (BasicType)typeBean.getBeanInstance();
                    this.explicitJavaTypeDescriptor = resolvedBasicType.getJavaTypeDescriptor();
                } else if (UserType.class.isAssignableFrom(registeredJtd.getJavaTypeClass())) {
                    ManagedBean userTypeBean = beanRegistry.getBean(registeredJtd.getJavaTypeClass());
                    resolvedBasicType = new CustomType((UserType)userTypeBean.getBeanInstance(), sessionFactory.getTypeConfiguration());
                    this.explicitJavaTypeDescriptor = resolvedBasicType.getJavaTypeDescriptor();
                } else {
                    this.explicitJavaTypeDescriptor = jtdRegistry.getDescriptor(definition.type());
                }
            }
        }
        this.explicitType = resolvedBasicType;
    }

    public ResultMementoBasicStandard(String explicitColumnName, BasicType<?> explicitType, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = explicitColumnName;
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = explicitType != null ? explicitType.getJavaTypeDescriptor() : null;
    }

    @Override
    public ResultBuilderBasicValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        return new CompleteResultBuilderBasicValuedStandard(this.explicitColumnName, this.explicitType, this.explicitJavaTypeDescriptor);
    }
}

