/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderLegacy
implements DynamicFetchBuilder,
NativeQuery.FetchReturn {
    private final String tableAlias;
    private final String ownerTableAlias;
    private final String fetchableName;
    private final List<String> columnNames;
    private final DynamicResultBuilderEntityStandard resultBuilderEntity;

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, String fetchableName, List<String> columnNames) {
        this.tableAlias = tableAlias;
        this.ownerTableAlias = ownerTableAlias;
        this.fetchableName = fetchableName;
        this.columnNames = columnNames;
        this.resultBuilderEntity = null;
    }

    public DynamicFetchBuilderLegacy(String tableAlias, String ownerTableAlias, String fetchableName, List<String> columnNames, DynamicResultBuilderEntityStandard resultBuilderEntity) {
        this.tableAlias = tableAlias;
        this.ownerTableAlias = ownerTableAlias;
        this.fetchableName = fetchableName;
        this.columnNames = columnNames;
        this.resultBuilderEntity = resultBuilderEntity;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public String getOwnerAlias() {
        return this.ownerTableAlias;
    }

    @Override
    public String getFetchableName() {
        return this.fetchableName;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        ForeignKeyDescriptor keyDescriptor;
        TableGroup tableGroup;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationState.getFromClauseAccess().findByAlias(this.ownerTableAlias);
        AttributeMapping attributeMapping = parent.getReferencedMappingContainer().findContainingEntityMapping().findDeclaredAttributeMapping(this.fetchableName);
        if (attributeMapping instanceof TableGroupJoinProducer) {
            SqlAliasBaseConstant sqlAliasBase = new SqlAliasBaseConstant(this.tableAlias);
            TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)attributeMapping)).createTableGroupJoin(fetchPath, ownerTableGroup, this.tableAlias, SqlAstJoinType.INNER, true, LockMode.NONE, s -> sqlAliasBase, creationState.getSqlExpressionResolver(), creationState.getCreationContext());
            tableGroup = tableGroupJoin.getJoinedGroup();
            creationState.getFromClauseAccess().registerTableGroup(fetchPath, tableGroup);
        } else {
            tableGroup = ownerTableGroup;
        }
        if (attributeMapping instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)attributeMapping;
            keyDescriptor = pluralAttributeMapping.getKeyDescriptor();
        } else {
            assert (attributeMapping instanceof ToOneAttributeMapping);
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
            keyDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
        }
        keyDescriptor.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection(this.columnNames.get(selectionIndex), SqlExpressionResolver.createColumnReferenceKey(tableGroup.getTableReference(selectableMapping.getContainingTableExpression()), selectableMapping.getSelectionExpression()), selectableMapping.getJdbcMapping(), jdbcResultsMetadata, domainResultCreationState));
        assert (this.resultBuilderEntity != null);
        return this.resultBuilderEntity.buildFetch(parent, attributeMapping, jdbcResultsMetadata, creationState);
    }

    private void resolveSqlSelection(String columnAlias, String columnKey, JdbcMapping jdbcMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(columnKey, state -> {
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(columnAlias);
            int valuesArrayPosition = jdbcPosition - 1;
            return new SqlSelectionImpl(valuesArrayPosition, jdbcMapping);
        }), jdbcMapping.getMappedJavaTypeDescriptor(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public NativeQuery.FetchReturn setLockMode(LockMode lockMode) {
        return null;
    }

    @Override
    public NativeQuery.FetchReturn addProperty(String propertyName, String columnAlias) {
        return null;
    }

    @Override
    public NativeQuery.ReturnProperty addProperty(String propertyName) {
        return null;
    }
}

