/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.internal.util.streams.StingArrayCollector;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement sqm;
    private final DomainParameterXref domainParameterXref;
    private final RowTransformer<R> rowTransformer;
    private final SqmInterpreter<List<R>, Void> listInterpreter;
    private final SqmInterpreter<ScrollableResultsImplementor<R>, ScrollMode> scrollInterpreter;
    private volatile CacheableSqmInterpretation cacheableSqmInterpretation;

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, Class<R> resultType, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = this.determineRowTransformer(sqm, resultType, queryOptions);
        this.listInterpreter = (unused, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcSelect jdbcSelect = sqmInterpretation.getJdbcSelect();
            try {
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
                List<R> list = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, SqlOmittingQueryOptions.omitSqlQueryOptions(executionContext, jdbcSelect), this.rowTransformer, true);
                return list;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.scrollInterpreter = (scrollMode, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            try {
                ScrollableResultsImplementor<R> scrollableResultsImplementor = executionContext.getSession().getFactory().getJdbcServices().getJdbcSelectExecutor().scroll(sqmInterpretation.getJdbcSelect(), (ScrollMode)((Object)scrollMode), jdbcParameterBindings, executionContext, this.rowTransformer);
                return scrollableResultsImplementor;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
    }

    private RowTransformer<R> determineRowTransformer(SqmSelectStatement sqm, Class<R> resultType, QueryOptions queryOptions) {
        if (resultType == null || resultType.isArray()) {
            if (queryOptions.getTupleTransformer() != null) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            return RowTransformerPassThruImpl.instance();
        }
        List<SqmSelection> selections = ((SqmQueryPart)sqm.getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
        if (Tuple.class.isAssignableFrom(resultType)) {
            if (queryOptions.getTupleTransformer() == null) {
                IdentityHashMap tupleElementMap = new IdentityHashMap(selections.size());
                for (int i = 0; i < selections.size(); ++i) {
                    SqmSelection selection = selections.get(i);
                    tupleElementMap.put(selection.getSelectableNode(), i);
                }
                return new RowTransformerJpaTupleImpl(new TupleMetadata(tupleElementMap));
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + queryOptions.getTupleTransformer());
        }
        if (queryOptions.getTupleTransformer() != null) {
            return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (selections.size() > 1) {
            throw new IllegalQueryOperationException("Query defined multiple selections, return cannot be typed (other that Object[] or Tuple)");
        }
        return RowTransformerSingularReturnImpl.instance();
    }

    private RowTransformer<R> makeRowTransformerTupleTransformerAdapter(SqmSelectStatement sqm, QueryOptions queryOptions) {
        return new RowTransformerTupleTransformerAdapter(((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections().stream().map(SqmSelection::getAlias).collect(StingArrayCollector.INSTANCE), queryOptions.getTupleTransformer());
    }

    @Override
    public List<R> performList(ExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return Collections.emptyList();
        }
        return this.withCacheableSqmInterpretation(executionContext, null, this.listInterpreter);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        return this.withCacheableSqmInterpretation(executionContext, scrollMode, this.scrollInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> T withCacheableSqmInterpretation(ExecutionContext executionContext, X context, SqmInterpreter<T, X> interpreter) {
        CacheableSqmInterpretation localCopy = this.cacheableSqmInterpretation;
        JdbcParameterBindings jdbcParameterBindings = null;
        if (localCopy == null) {
            ConcreteSqmSelectQueryPlan concreteSqmSelectQueryPlan = this;
            synchronized (concreteSqmSelectQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                    jdbcParameterBindings = localCopy.firstParameterBindings;
                    localCopy.firstParameterBindings = null;
                    this.cacheableSqmInterpretation = localCopy;
                }
            }
        } else {
            if (localCopy.jdbcSelect.dependsOnParameterBindings()) {
                jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
            }
            if (!localCopy.jdbcSelect.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                jdbcParameterBindings = localCopy.firstParameterBindings;
                localCopy.firstParameterBindings = null;
                this.cacheableSqmInterpretation = localCopy;
            }
        }
        if (jdbcParameterBindings == null) {
            jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
        }
        return interpreter.interpret(context, executionContext, localCopy, jdbcParameterBindings);
    }

    private JdbcParameterBindings createJdbcParameterBindings(CacheableSqmInterpretation sqmInterpretation, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.getJdbcParamsXref(), session.getFactory().getDomainModel(), sqmInterpretation.getTableGroupAccess()::findTableGroup, sqmInterpretation.getSqmParameterMappingModelTypes()::get, session);
        sqmInterpretation.getJdbcSelect().bindFilterJdbcParameters(jdbcParameterBindings);
        return jdbcParameterBindings;
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        SqmTranslatorFactory sqmTranslatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<SelectStatement> sqmConverter = sqmTranslatorFactory.createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), sessionFactory);
        SqmTranslation<SelectStatement> sqmInterpretation = sqmConverter.translate();
        FromClauseAccess tableGroupAccess = sqmConverter.getFromClauseAccess();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqlAstTranslator<JdbcSelect> selectTranslator = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqmInterpretation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, session.getFactory().getDomainModel(), tableGroupAccess::findTableGroup, sqmInterpretation.getSqmParameterMappingModelTypeResolutions()::get, session);
        JdbcSelect jdbcSelect = selectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return new CacheableSqmInterpretation(jdbcSelect, tableGroupAccess, jdbcParamsXref, sqmInterpretation.getSqmParameterMappingModelTypeResolutions(), jdbcParameterBindings);
    }

    private static class CacheableSqmInterpretation {
        private final JdbcSelect jdbcSelect;
        private final FromClauseAccess tableGroupAccess;
        private final Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamsXref;
        private final Map<SqmParameter, MappingModelExpressable> sqmParameterMappingModelTypes;
        private transient JdbcParameterBindings firstParameterBindings;

        CacheableSqmInterpretation(JdbcSelect jdbcSelect, FromClauseAccess tableGroupAccess, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamsXref, Map<SqmParameter, MappingModelExpressable> sqmParameterMappingModelTypes, JdbcParameterBindings firstParameterBindings) {
            this.jdbcSelect = jdbcSelect;
            this.tableGroupAccess = tableGroupAccess;
            this.jdbcParamsXref = jdbcParamsXref;
            this.sqmParameterMappingModelTypes = sqmParameterMappingModelTypes;
            this.firstParameterBindings = firstParameterBindings;
        }

        JdbcSelect getJdbcSelect() {
            return this.jdbcSelect;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> getJdbcParamsXref() {
            return this.jdbcParamsXref;
        }

        public Map<SqmParameter, MappingModelExpressable> getSqmParameterMappingModelTypes() {
            return this.sqmParameterMappingModelTypes;
        }

        JdbcParameterBindings getFirstParameterBindings() {
            return this.firstParameterBindings;
        }

        void setFirstParameterBindings(JdbcParameterBindings firstParameterBindings) {
            this.firstParameterBindings = firstParameterBindings;
        }
    }

    private static interface SqmInterpreter<T, X> {
        public T interpret(X var1, ExecutionContext var2, CacheableSqmInterpretation var3, JdbcParameterBindings var4);
    }
}

