/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;

public class MultiTableSqmMutationConverter
extends BaseSqmToSqlAstConverter<Statement> {
    private final EntityMappingType mutatingEntityDescriptor;
    private final TableGroup mutatingTableGroup;
    private SqmParameterResolutionConsumer parameterResolutionConsumer;

    public MultiTableSqmMutationConverter(EntityMappingType mutatingEntityDescriptor, String mutatingEntityExplicitAlias, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        super(creationContext, null, queryOptions, loadQueryInfluencers, domainParameterXref, domainParameterBindings);
        this.mutatingEntityDescriptor = mutatingEntityDescriptor;
        SqlAstProcessingStateImpl rootProcessingState = new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent);
        this.pushProcessingState(rootProcessingState);
        NavigablePath navigablePath = new NavigablePath(mutatingEntityDescriptor.getEntityName(), mutatingEntityExplicitAlias);
        this.mutatingTableGroup = mutatingEntityDescriptor.createRootTableGroup(navigablePath, mutatingEntityExplicitAlias, LockMode.PESSIMISTIC_WRITE, () -> predicate -> {}, this, creationContext.getSessionFactory());
        this.getFromClauseAccess().registerTableGroup(navigablePath, this.mutatingTableGroup);
    }

    public EntityMappingType getMutatingEntityDescriptor() {
        return this.mutatingEntityDescriptor;
    }

    public TableGroup getMutatingTableGroup() {
        return this.mutatingTableGroup;
    }

    @Override
    public Stack<SqlAstProcessingState> getProcessingStateStack() {
        return super.getProcessingStateStack();
    }

    public void visitSetClause(SqmSetClause setClause, Consumer<Assignment> assignmentConsumer, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        for (SqmAssignment assignment : setClause.getAssignments()) {
            this.visitAssignment(assignment, assignmentConsumer);
        }
    }

    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        throw new UnsupportedOperationException();
    }

    private void visitAssignment(SqmAssignment sqmAssignment, Consumer<Assignment> assignmentConsumer) {
        Assignable assignable = (Assignable)sqmAssignment.getTargetPath().accept(this);
        Expression value = (Expression)sqmAssignment.getValue().accept(this);
        assignmentConsumer.accept(new Assignment(assignable, value));
    }

    @Override
    public Assignment visitAssignment(SqmAssignment sqmAssignment) {
        return new Assignment((Assignable)sqmAssignment.getTargetPath().accept(this), (Expression)sqmAssignment.getValue().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Predicate visitWhereClause(SqmWhereClause sqmWhereClause, final Consumer<ColumnReference> restrictionColumnReferenceConsumer, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        if (sqmWhereClause == null || sqmWhereClause.getPredicate() == null) {
            return null;
        }
        final SqlAstProcessingState rootProcessingState = this.getCurrentProcessingState();
        SqlAstProcessingStateImpl restrictionProcessingState = new SqlAstProcessingStateImpl(rootProcessingState, this, this.getCurrentClauseStack()::getCurrent){

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this;
            }

            @Override
            public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                Expression expression = rootProcessingState.getSqlExpressionResolver().resolveSqlExpression(key, creator);
                if (expression instanceof ColumnReference) {
                    restrictionColumnReferenceConsumer.accept((ColumnReference)expression);
                }
                return expression;
            }
        };
        this.pushProcessingState(restrictionProcessingState, this.getFromClauseIndex());
        try {
            Predicate predicate = (Predicate)sqmWhereClause.getPredicate().accept(this);
            return predicate;
        }
        finally {
            this.popProcessingStateStack();
            this.parameterResolutionConsumer = null;
        }
    }

    @Override
    public Predicate visitWhereClause(SqmWhereClause whereClause) {
        return (Predicate)super.visitWhereClause(whereClause);
    }

    @Override
    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        assert (this.parameterResolutionConsumer != null);
        Expression expression = super.consumeSqmParameter(sqmParameter);
        List<List<JdbcParameter>> jdbcParameters = this.getJdbcParamsBySqmParam().get(sqmParameter);
        MappingModelExpressable mappingType = this.getSqmParameterMappingModelExpressableResolutions().get(sqmParameter);
        this.parameterResolutionConsumer.accept(sqmParameter, mappingType, jdbcParameters.get(jdbcParameters.size() - 1));
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSelectClause(SqmSelectClause sqmSelectClause, QuerySpec sqlQuerySpec, final Consumer<ColumnReference> columnReferenceConsumer, SqmParameterResolutionConsumer parameterResolutionConsumer) {
        assert (sqmSelectClause != null);
        this.parameterResolutionConsumer = parameterResolutionConsumer;
        final SqlAstProcessingState rootProcessingState = this.getCurrentProcessingState();
        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, rootProcessingState, this, r -> new BaseSqmToSqlAstConverter.SqmAliasedNodePositionTracker((SqlExpressionResolver)r, sqmSelectClause.getSelectionItems().size()), this.getCurrentClauseStack()::getCurrent){

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this;
            }

            @Override
            public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                Expression expression = rootProcessingState.getSqlExpressionResolver().resolveSqlExpression(key, creator);
                if (expression instanceof ColumnReference) {
                    columnReferenceConsumer.accept((ColumnReference)expression);
                }
                return expression;
            }
        };
        this.pushProcessingState(processingState, this.getFromClauseIndex());
        try {
            for (int i = 0; i < sqmSelectClause.getSelectionItems().size(); ++i) {
                DomainResultProducer domainResultProducer = (DomainResultProducer)sqmSelectClause.getSelectionItems().get(i).accept(this);
                domainResultProducer.applySqlSelections(this);
            }
        }
        finally {
            this.popProcessingStateStack();
            this.parameterResolutionConsumer = null;
        }
    }

    public static interface SqmParameterResolutionConsumer {
        public void accept(SqmParameter var1, MappingModelExpressable var2, List<JdbcParameter> var3);
    }
}

