/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.param.VersionTypeSeedParameterSpecification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.StandardSqmTranslation;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DiscriminatedAssociationPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EntityValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.NonAggregatedCompositeValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.PluralValuedSimplePathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmMapEntryResult;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.TypeHelper;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollate;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collate;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.NullnessLiteral;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiation;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserVersionType;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter<T extends Statement>
extends BaseSemanticQueryWalker
implements SqmTranslator<T>,
DomainResultCreationState,
JdbcTypeDescriptorIndicators {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final SqmStatement<?> statement;
    private final QueryOptions queryOptions;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final Map<SqmParameter, MappingModelExpressable> sqmParameterMappingModelTypes = new LinkedHashMap<SqmParameter, MappingModelExpressable>();
    private final Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;
    private final List<DomainResult<?>> domainResults;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private boolean resolvingCircularFetch;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private Map<String, FilterPredicate> collectionFilterPredicates;
    private OrderByFragmentConsumer orderByFragmentConsumer;
    private Map<String, NavigablePath> joinPathBySqmJoinFullPath = new HashMap<String, NavigablePath>();
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Stack<FromClauseIndex> fromClauseIndexStack = new StandardStack<FromClauseIndex>();
    private SqlAstProcessingState lastPoppedProcessingState;
    private FromClauseIndex lastPoppedFromClauseIndex;
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>();
    private SqmByUnit appliedByUnit;
    private Expression adjustedTimestamp;
    private SqmExpressable<?> adjustedTimestampType;
    private Expression adjustmentScale;
    private boolean negativeAdjustment;
    private boolean trackSelectionsForGroup;
    protected Predicate additionalRestrictions;
    private final Map<SqmParameter, List<List<JdbcParameter>>> jdbcParamsBySqmParam = new IdentityHashMap<SqmParameter, List<List<JdbcParameter>>>();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    protected final Stack<Supplier<MappingModelExpressable>> inferrableTypeAccessStack = new StandardStack<Supplier<MappingModelExpressable>>(() -> null);

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, SqmStatement<?> statement, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext.getServiceRegistry());
        this.creationContext = creationContext;
        this.statement = statement;
        if (statement instanceof SqmSelectStatement) {
            this.domainResults = new ArrayList(((SqmQueryPart)((SqmSelectStatement)statement).getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections().size());
            AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
            this.entityGraphTraversalState = appliedGraph != null && appliedGraph.getSemantic() != null && appliedGraph.getGraph() != null ? new StandardEntityGraphTraversalStateImpl(appliedGraph.getSemantic(), appliedGraph.getGraph()) : null;
        } else if (statement instanceof SqmInsertSelectStatement) {
            this.domainResults = new ArrayList(((SqmInsertSelectStatement)statement).getSelectQueryPart().getFirstQuerySpec().getSelectClause().getSelectionItems().size());
            this.entityGraphTraversalState = null;
        } else {
            this.domainResults = null;
            this.entityGraphTraversalState = null;
        }
        this.queryOptions = queryOptions;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.jpaCriteriaParamResolutions = domainParameterXref.getParameterResolutions().getJpaCriteriaParamResolutions();
    }

    public Map<SqmParameter, MappingModelExpressable> getSqmParameterMappingModelExpressableResolutions() {
        return this.sqmParameterMappingModelTypes;
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected void pushProcessingState(SqlAstProcessingState processingState) {
        this.pushProcessingState(processingState, new FromClauseIndex(this.getFromClauseIndex()));
    }

    protected void pushProcessingState(SqlAstProcessingState processingState, FromClauseIndex fromClauseIndex) {
        this.fromClauseIndexStack.push(fromClauseIndex);
        this.processingStateStack.push(processingState);
    }

    protected void popProcessingStateStack() {
        this.lastPoppedFromClauseIndex = this.fromClauseIndexStack.pop();
        this.lastPoppedProcessingState = this.processingStateStack.pop();
    }

    protected SqmStatement<?> getStatement() {
        return this.statement;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.creationContext.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath);
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        LockOptions lockOptions = this.getQueryOptions().getLockOptions();
        return lockOptions.getScope() || identificationVariable == null ? lockOptions.getLockMode() : lockOptions.getEffectiveLockMode(identificationVariable);
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public FromClauseIndex getFromClauseIndex() {
        return (FromClauseIndex)this.getFromClauseAccess();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        if (fromClauseIndex == null) {
            return this.lastPoppedFromClauseIndex;
        }
        return fromClauseIndex;
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    @Override
    public SqmTranslation<T> translate() {
        SqmStatement<?> sqmStatement = this.getStatement();
        Statement statement = (Statement)sqmStatement.accept(this);
        return new StandardSqmTranslation<Statement>(statement, this.getJdbcParamsBySqmParam(), this.sqmParameterMappingModelTypes, this.lastPoppedProcessingState.getSqlExpressionResolver(), this.getFromClauseAccess());
    }

    @Override
    public Statement visitStatement(SqmStatement<?> sqmStatement) {
        return (Statement)sqmStatement.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatement visitUpdateStatement(SqmUpdateStatement sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        JpaRoot sqmTarget = sqmStatement.getTarget();
        String entityName = ((SqmRoot)sqmTarget).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmTarget)).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, sqmStatement.getRoot().getAlias(), LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM UPDATE");
            }
            if (((AbstractSqmFrom)((Object)sqmTarget)).hasJoins()) {
                throw new HibernateException("SQM UPDATE does not support explicit joins");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            this.applyManipulationImplicitJoins((SqmPath<?>)((Object)sqmTarget), rootTableGroup);
            Object assignments = this.visitSetClause(sqmStatement.getSetClause());
            this.addVersionedAssignment(((List)assignments)::add, sqmStatement);
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityDescriptor), rootTableGroup, AbstractSqlAstTranslator.rendersTableReferenceAlias(Clause.UPDATE));
            if (filterPredicate != null) {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = sqmStatement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            UpdateStatement updateStatement = new UpdateStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), (List<Assignment>)assignments, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return updateStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    private void applyManipulationImplicitJoins(SqmPath<?> sqmPath, TableGroup correspondingTableGroup) {
        this.consumeReusablePaths(sqmPath, correspondingTableGroup, BaseSqmToSqlAstConverter::verifyManipulationImplicitJoin);
    }

    private static void verifyManipulationImplicitJoin(SqmPath<?> joinedPath) {
        if (!(joinedPath instanceof SqmEmbeddedValuedSimplePath)) {
            throw new QueryException("Manipulation query may only contain embeddable joins");
        }
    }

    public void addVersionedAssignment(Consumer<Assignment> assignmentConsumer, SqmUpdateStatement<?> sqmStatement) {
        Expression value;
        if (!sqmStatement.isVersioned()) {
            return;
        }
        EntityPersister persister = this.creationContext.getDomainModel().findEntityDescriptor(((SqmRoot)sqmStatement.getTarget()).getEntityName());
        if (!persister.isVersioned()) {
            throw new SemanticException("increment option specified for update of non-versioned entity");
        }
        VersionType<?> versionType = persister.getVersionType();
        if (versionType instanceof UserVersionType) {
            throw new SemanticException("user-defined version types not supported for increment option");
        }
        EntityVersionMapping versionMapping = persister.getVersionMapping();
        List<ColumnReference> targetColumnReferences = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)sqmStatement.getRoot().get(versionMapping.getPartName()), this, this).getColumnReferences();
        assert (targetColumnReferences.size() == 1);
        ColumnReference versionColumn = targetColumnReferences.get(0);
        if (this.isTimestampBasedVersion(versionType)) {
            value = new VersionTypeSeedParameterSpecification(versionType);
        } else {
            BasicValuedMapping basicValuedMapping = (BasicValuedMapping)((Object)versionType);
            value = new BinaryArithmeticExpression(versionColumn, BinaryArithmeticOperator.ADD, new QueryLiteral<Integer>(1, basicValuedMapping), basicValuedMapping);
        }
        assignmentConsumer.accept(new Assignment(versionColumn, value));
    }

    private boolean isTimestampBasedVersion(VersionType<?> versionType) {
        if (versionType instanceof BasicType) {
            return ((BasicType)((Object)versionType)).getJdbcTypeDescriptor().isTemporal();
        }
        Class javaType = versionType.getReturnedClass();
        return Date.class.isAssignableFrom(javaType) || Calendar.class.isAssignableFrom(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(setClause.getAssignments().size());
        for (SqmAssignment sqmAssignment : setClause.getAssignments()) {
            SqmPathInterpretation assignedPathInterpretation;
            final ArrayList targetColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    targetColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                assignedPathInterpretation = (SqmPathInterpretation)sqmAssignment.getTargetPath().accept(this);
            }
            finally {
                this.popProcessingStateStack();
            }
            this.inferrableTypeAccessStack.push(assignedPathInterpretation::getExpressionType);
            final ArrayList valueColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    valueColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                int assignedPathJdbcCount;
                if (sqmAssignment.getValue() instanceof SqmParameter) {
                    SqmParameter sqmParameter = (SqmParameter)sqmAssignment.getValue();
                    this.consumeSqmParameter(sqmParameter, (index, jdbcParameter) -> assignments.add(new Assignment((Assignable)targetColumnReferences.get((int)index), (Expression)jdbcParameter)));
                    continue;
                }
                Expression valueExpression = (Expression)sqmAssignment.getValue().accept(this);
                int valueExprJdbcCount = this.getKeyExpressable(valueExpression.getExpressionType()).getJdbcTypeCount();
                if (valueExprJdbcCount != (assignedPathJdbcCount = this.getKeyExpressable(assignedPathInterpretation.getExpressionType()).getJdbcTypeCount())) {
                    SqlTreeCreationLogger.LOGGER.debugf("JDBC type count does not match in UPDATE assignment between the assigned-path and the assigned-value; this will likely lead to problems executing the query", new Object[0]);
                }
                assert (assignedPathJdbcCount == valueExprJdbcCount);
                for (ColumnReference columnReference : targetColumnReferences) {
                    assignments.add(new Assignment(columnReference, valueExpression));
                }
            }
            finally {
                this.popProcessingStateStack();
                this.inferrableTypeAccessStack.pop();
            }
        }
        return assignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStatement visitDeleteStatement(SqmDeleteStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        String entityName = ((SqmRoot)statement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, statement.getRoot().getAlias(), LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityDescriptor), rootTableGroup, AbstractSqlAstTranslator.rendersTableReferenceAlias(Clause.DELETE));
            if (filterPredicate != null) {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = statement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            DeleteStatement deleteStatement = new DeleteStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return deleteStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertSelectStatement(SqmInsertSelectStatement<?> sqmStatement) {
        InsertStatement insertStatement;
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        SqmQueryPart<?> selectQueryPart = sqmStatement.getSelectQueryPart();
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, selectQueryPart.getFirstQuerySpec().getSelectClause().getSelectionItems().size()), this.getCurrentClauseStack()::getCurrent));
        this.currentClauseStack.push(Clause.INSERT);
        boolean needsVersionInsert = entityDescriptor.isVersioned();
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            insertStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            if (needsVersionInsert) {
                String versionAttributeName = entityDescriptor.getVersionMapping().getVersionAttribute().getAttributeName();
                for (int i = 0; i < targetPaths.size(); ++i) {
                    SqmPath path = targetPaths.get(i);
                    if (versionAttributeName.equals(path.getNavigablePath().getLocalName())) {
                        needsVersionInsert = false;
                    }
                    Assignable assignable = (Assignable)path.accept(this);
                    insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
                }
                if (needsVersionInsert) {
                    List<ColumnReference> targetColumnReferences = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)((AbstractSqmPath)((Object)sqmStatement.getTarget())).get(versionAttributeName), this, this).getColumnReferences();
                    assert (targetColumnReferences.size() == 1);
                    insertStatement.addTargetColumnReferences(targetColumnReferences);
                }
            } else {
                for (int i = 0; i < targetPaths.size(); ++i) {
                    Assignable assignable = (Assignable)targetPaths.get(i).accept(this);
                    insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
                }
            }
        }
        finally {
            this.popProcessingStateStack();
            this.currentClauseStack.pop();
        }
        insertStatement.setSourceSelectStatement((QueryPart)this.visitQueryPart((SqmQueryPart)selectQueryPart));
        if (needsVersionInsert) {
            VersionType<?> versionType = entityDescriptor.getVersionType();
            VersionTypeSeedParameterSpecification expression = new VersionTypeSeedParameterSpecification(versionType);
            insertStatement.getSourceSelectStatement().forEachQuerySpec(querySpec -> querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, expression)));
        }
        return insertStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertValuesStatement(SqmInsertValuesStatement<?> sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            InsertStatement insertValuesStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            for (SqmPath target : targetPaths) {
                Assignable assignable = (Assignable)target.accept(this);
                insertValuesStatement.addTargetColumnReferences(assignable.getColumnReferences());
            }
            List<SqmValues> valuesList = sqmStatement.getValuesList();
            for (SqmValues sqmValues : valuesList) {
                insertValuesStatement.getValuesList().add(this.visitValues(sqmValues));
            }
            InsertStatement insertStatement = insertValuesStatement;
            return insertStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    @Override
    public Values visitValues(SqmValues sqmValues) {
        Values values = new Values();
        for (SqmExpression<?> expression : sqmValues.getExpressions()) {
            values.getExpressions().add((Expression)expression.accept(this));
        }
        return values;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        Object queryPart = this.visitQueryPart((SqmQueryPart)statement.getQueryPart());
        return new SelectStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (QueryPart)queryPart, this.domainResults);
    }

    @Override
    public DynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaTypeDescriptor targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            if (!(sqmArgument.getSelectableNode() instanceof SqmDynamicInstantiation)) {
                this.currentSqlSelectionCollector().next();
            }
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.getSelectableNode().accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer, this);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <X> JavaTypeDescriptor<X> interpretInstantiationTarget(SqmDynamicInstantiationTarget<?> instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public CteStatement visitCteStatement(SqmCteStatement<?> sqmCteStatement) {
        CteTable cteTable = BaseSqmToSqlAstConverter.createCteTable(sqmCteStatement.getCteTable(), this.getCreationContext().getSessionFactory());
        return new CteStatement(cteTable, (Statement)this.visitStatement((SqmStatement)sqmCteStatement.getCteDefinition()), sqmCteStatement.getSearchClauseKind(), this.visitSearchBySpecifications(cteTable, sqmCteStatement.getSearchBySpecifications()), this.visitCycleColumns(cteTable, sqmCteStatement.getCycleColumns()), this.findCteColumn(cteTable, sqmCteStatement.getCycleMarkColumn()), sqmCteStatement.getCycleValue(), sqmCteStatement.getNoCycleValue());
    }

    protected List<SearchClauseSpecification> visitSearchBySpecifications(CteTable cteTable, List<SqmSearchClauseSpecification> searchBySpecifications) {
        if (searchBySpecifications == null || searchBySpecifications.isEmpty()) {
            return null;
        }
        int size = searchBySpecifications.size();
        ArrayList<SearchClauseSpecification> searchClauseSpecifications = new ArrayList<SearchClauseSpecification>(size);
        for (int i = 0; i < size; ++i) {
            SqmSearchClauseSpecification specification = searchBySpecifications.get(i);
            this.forEachCteColumn(cteTable, specification.getCteColumn(), cteColumn -> searchClauseSpecifications.add(new SearchClauseSpecification((CteColumn)cteColumn, specification.getSortOrder(), specification.getNullPrecedence())));
        }
        return searchClauseSpecifications;
    }

    protected CteColumn findCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn) {
        if (cteColumn == null) {
            return null;
        }
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Couldn't find cte column %s in cte %s!", cteColumn.getColumnName(), cteTable.getTableExpression()));
    }

    protected void forEachCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn, Consumer<CteColumn> consumer) {
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            consumer.accept(column);
        }
    }

    protected List<CteColumn> visitCycleColumns(CteTable cteTable, List<SqmCteTableColumn> cycleColumns) {
        if (cycleColumns == null || cycleColumns.isEmpty()) {
            return null;
        }
        int size = cycleColumns.size();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(size);
        for (int i = 0; i < size; ++i) {
            this.forEachCteColumn(cteTable, cycleColumns.get(i), columns::add);
        }
        return columns;
    }

    public static CteTable createCteTable(SqmCteTable sqmCteTable, SessionFactoryImplementor factory) {
        List<SqmCteTableColumn> sqmCteColumns = sqmCteTable.getColumns();
        ArrayList<CteColumn> sqlCteColumns = new ArrayList<CteColumn>(sqmCteColumns.size());
        for (int i = 0; i < sqmCteColumns.size(); ++i) {
            SqmCteTableColumn sqmCteTableColumn = sqmCteColumns.get(i);
            ModelPart modelPart = sqmCteTableColumn.getType();
            if (modelPart instanceof Association) {
                modelPart = ((Association)modelPart).getForeignKeyDescriptor();
            }
            if (modelPart instanceof EmbeddableValuedModelPart) {
                modelPart.forEachJdbcType((index, jdbcMapping) -> sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName() + "_" + index, (JdbcMapping)jdbcMapping)));
                continue;
            }
            sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName(), ((BasicValuedMapping)((Object)modelPart)).getJdbcMapping()));
        }
        return new CteTable(sqmCteTable.getCteName(), sqlCteColumns, factory);
    }

    @Override
    public Map<String, CteStatement> visitCteContainer(SqmCteContainer consumer) {
        Collection<SqmCteStatement<?>> sqmCteStatements = consumer.getCteStatements();
        LinkedHashMap<String, CteStatement> cteStatements = new LinkedHashMap<String, CteStatement>(sqmCteStatements.size());
        for (SqmCteStatement<?> sqmCteStatement : sqmCteStatements) {
            Object cteStatement = this.visitCteStatement((SqmCteStatement)sqmCteStatement);
            cteStatements.put(((CteStatement)cteStatement).getCteTable().getTableExpression(), (CteStatement)cteStatement);
        }
        return cteStatements;
    }

    @Override
    public QueryPart visitQueryPart(SqmQueryPart<?> queryPart) {
        return (QueryPart)super.visitQueryPart(queryPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryGroup visitQueryGroup(SqmQueryGroup<?> queryGroup) {
        List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
        int size = queryParts.size();
        ArrayList<QueryPart> newQueryParts = new ArrayList<QueryPart>(size);
        QueryGroup group = new QueryGroup(this.getProcessingStateStack().isEmpty(), queryGroup.getSetOperator(), newQueryParts);
        if (queryGroup.getOrderByClause() != null && queryGroup.getOrderByClause().hasPositionalSortItem()) {
            this.trackSelectionsForGroup = true;
        }
        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(group, this.getCurrentProcessingState(), this, DelegatingSqmAliasedNodeCollector::new, this.currentClauseStack::getCurrent);
        DelegatingSqmAliasedNodeCollector collector = (DelegatingSqmAliasedNodeCollector)processingState.getSqlExpressionResolver();
        this.pushProcessingState(processingState);
        try {
            newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(0)));
            collector.setSqmAliasedNodeCollector((SqmAliasedNodeCollector)((Object)this.lastPoppedProcessingState.getSqlExpressionResolver()));
            this.visitOrderByOffsetAndFetch(queryGroup, group);
            this.trackSelectionsForGroup = false;
            for (int i = 1; i < size; ++i) {
                newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            QueryGroup queryGroup2 = group;
            return queryGroup2;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec<?> sqmQuerySpec) {
        boolean topLevel = this.getProcessingStateStack().isEmpty();
        QuerySpec sqlQuerySpec = new QuerySpec(topLevel, sqmQuerySpec.getFromClause().getNumberOfRoots());
        SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
        Predicate originalAdditionalRestrictions = this.additionalRestrictions;
        this.additionalRestrictions = null;
        boolean trackAliasedNodePositions = this.trackSelectionsForGroup ? true : (sqmQuerySpec.getOrderByClause() != null && sqmQuerySpec.getOrderByClause().hasPositionalSortItem() ? true : sqmQuerySpec.hasPositionalGroupItem());
        SqlAstQueryPartProcessingStateImpl processingState = trackAliasedNodePositions ? new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, selectClause.getSelectionItems().size()), this.currentClauseStack::getCurrent) : new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent);
        this.pushProcessingState(processingState);
        try {
            if (topLevel) {
                this.orderByFragmentConsumer = new StandardOrderByFragmentConsumer();
            }
            this.visitFromClause(sqmQuerySpec.getFromClause());
            this.visitSelectClause(selectClause);
            SqmWhereClause whereClause = sqmQuerySpec.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.currentClauseStack.push(Clause.WHERE);
                try {
                    sqlQuerySpec.applyPredicate((Predicate)whereClause.getPredicate().accept(this));
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            sqlQuerySpec.setGroupByClauseExpressions((List<Expression>)this.visitGroupByClause((List)sqmQuerySpec.getGroupByClauseExpressions()));
            if (sqmQuerySpec.getHavingClausePredicate() != null) {
                sqlQuerySpec.setHavingClauseRestrictions(this.visitHavingClause(sqmQuerySpec.getHavingClausePredicate()));
            }
            this.visitOrderByOffsetAndFetch(sqmQuerySpec, sqlQuerySpec);
            if (topLevel && this.statement instanceof SqmSelectStatement) {
                this.orderByFragmentConsumer.visitFragments((orderByFragment, tableGroup) -> orderByFragment.apply(sqlQuerySpec, (TableGroup)tableGroup, this));
                this.orderByFragmentConsumer = null;
                this.applyCollectionFilterPredicates(sqlQuerySpec);
            }
            this.joinPathBySqmJoinFullPath.clear();
            QuerySpec querySpec = sqlQuerySpec;
            return querySpec;
        }
        finally {
            if (this.additionalRestrictions != null) {
                sqlQuerySpec.applyPredicate(this.additionalRestrictions);
            }
            this.additionalRestrictions = originalAdditionalRestrictions;
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOrderByOffsetAndFetch(SqmQueryPart<?> sqmQueryPart, QueryPart sqlQueryPart) {
        if (sqmQueryPart.getOrderByClause() != null) {
            this.currentClauseStack.push(Clause.ORDER);
            try {
                for (SqmSortSpecification sortSpecification : sqmQueryPart.getOrderByClause().getSortSpecifications()) {
                    sqlQueryPart.addSortSpecification(this.visitSortSpecification(sortSpecification));
                }
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        sqlQueryPart.setOffsetClauseExpression((Expression)this.visitOffsetExpression((SqmExpression)sqmQueryPart.getOffsetExpression()));
        sqlQueryPart.setFetchClauseExpression((Expression)this.visitFetchExpression((SqmExpression)sqmQueryPart.getFetchExpression()), sqmQueryPart.getFetchClauseType());
    }

    private TableGroup findTableGroupByPath(NavigablePath navigablePath) {
        return this.getFromClauseAccess().getTableGroup(navigablePath);
    }

    protected void applyCollectionFilterPredicates(QuerySpec sqlQuerySpec) {
        List<TableGroup> roots = sqlQuerySpec.getFromClause().getRoots();
        if (roots != null && roots.size() == 1) {
            TableGroup root = roots.get(0);
            ModelPartContainer modelPartContainer = root.getModelPart();
            EntityPersister entityPersister = modelPartContainer.findContainingEntityMapping().getEntityPersister();
            assert (entityPersister instanceof Joinable);
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityPersister), root);
            if (filterPredicate != null) {
                sqlQuerySpec.applyPredicate(filterPredicate);
            }
            if (CollectionHelper.isNotEmpty(this.collectionFilterPredicates)) {
                root.getTableGroupJoins().forEach(tableGroupJoin -> this.collectionFilterPredicates.forEach((alias, predicate) -> {
                    if (tableGroupJoin.getJoinedGroup().getGroupAlias().equals(alias)) {
                        tableGroupJoin.applyPredicate((Predicate)predicate);
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        try {
            super.visitSelectClause(selectClause);
            SelectClause sqlSelectClause = this.currentQuerySpec().getSelectClause();
            sqlSelectClause.makeDistinct(selectClause.isDistinct());
            SelectClause selectClause2 = sqlSelectClause;
            return selectClause2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitSelection(SqmSelection<?> sqmSelection) {
        boolean collectDomainResults;
        boolean needsDomainResults;
        Map<Object, Object> resultProducers;
        if (sqmSelection.getSelectableNode() instanceof SqmJpaCompoundSelection) {
            SqmJpaCompoundSelection selectableNode = (SqmJpaCompoundSelection)sqmSelection.getSelectableNode();
            resultProducers = new HashMap(selectableNode.getSelectionItems().size());
            for (SqmSelectableNode<?> selectionItem : selectableNode.getSelectionItems()) {
                this.currentSqlSelectionCollector().next();
                resultProducers.put(selectionItem.getAlias(), (DomainResultProducer)selectionItem.accept(this));
            }
        } else {
            if (!(sqmSelection.getSelectableNode() instanceof SqmDynamicInstantiation)) {
                this.currentSqlSelectionCollector().next();
            }
            resultProducers = Collections.singletonMap(sqmSelection.getAlias(), (DomainResultProducer)sqmSelection.getSelectableNode().accept(this));
        }
        Stack<SqlAstProcessingState> processingStateStack = this.getProcessingStateStack();
        boolean bl = needsDomainResults = this.domainResults != null && this.currentClauseContributesToTopLevelSelectClause();
        if (processingStateStack.depth() == 1) {
            collectDomainResults = needsDomainResults;
        } else {
            SqlAstProcessingState current = processingStateStack.getCurrent();
            boolean bl2 = collectDomainResults = needsDomainResults && processingStateStack.findCurrentFirst(processingState -> {
                if (!(processingState instanceof SqlAstQueryPartProcessingState)) {
                    return Boolean.FALSE;
                }
                if (processingState == current) {
                    return null;
                }
                QueryPart part = ((SqlAstQueryPartProcessingState)processingState).getInflightQueryPart();
                if (part instanceof QueryGroup && ((QueryGroup)part).getQueryParts().isEmpty()) {
                    return null;
                }
                return Boolean.FALSE;
            }) == null;
        }
        if (collectDomainResults) {
            resultProducers.forEach((alias, r) -> this.domainResults.add(r.createDomainResult((String)alias, this)));
        } else {
            resultProducers.forEach((alias, r) -> r.applySqlSelections(this));
        }
        return null;
    }

    private boolean currentClauseContributesToTopLevelSelectClause() {
        return this.currentClauseStack.findCurrentFirst(clause -> clause == Clause.SELECT ? null : clause) == null;
    }

    protected Expression resolveGroupOrOrderByExpression(SqmExpression<?> groupByClauseExpression) {
        if (groupByClauseExpression instanceof SqmAliasedNodeRef) {
            int aliasedNodeOrdinal = ((SqmAliasedNodeRef)groupByClauseExpression).getPosition();
            int sqmPosition = aliasedNodeOrdinal - 1;
            List<SqlSelection> selections = this.currentSqlSelectionCollector().getSelections(sqmPosition);
            assert (selections != null) : String.format(Locale.ROOT, "No SqlSelections for SQM position `%s`", sqmPosition);
            ArrayList<SqlSelectionExpression> expressions = new ArrayList<SqlSelectionExpression>(selections.size());
            block0: for (int i = 0; i < selections.size(); ++i) {
                SqlSelection selection = selections.get(i);
                for (int j = 0; j < i; ++j) {
                    if (selections.get(j) == selection) continue block0;
                }
                expressions.add(new SqlSelectionExpression(selection));
            }
            if (expressions.size() == 1) {
                return (Expression)expressions.get(0);
            }
            return new SqlTuple(expressions, null);
        }
        return (Expression)groupByClauseExpression.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Expression> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
        if (!groupByClauseExpressions.isEmpty()) {
            this.currentClauseStack.push(Clause.GROUP);
            try {
                ArrayList<Expression> expressions = new ArrayList<Expression>(groupByClauseExpressions.size());
                for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                    expressions.add(this.resolveGroupOrOrderByExpression(groupByClauseExpression));
                }
                ArrayList<Expression> arrayList = expressions;
                return arrayList;
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Predicate visitHavingClause(SqmPredicate sqmPredicate) {
        if (sqmPredicate == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.HAVING);
        try {
            Predicate predicate = (Predicate)sqmPredicate.accept(this);
            return predicate;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        return new SortSpecification(this.resolveGroupOrOrderByExpression(sortSpecification.getSortExpression()), null, sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence());
    }

    public QuerySpec visitOffsetAndFetchExpressions(QuerySpec sqlQuerySpec, SqmQuerySpec<?> sqmQuerySpec) {
        Object offsetExpression = this.visitOffsetExpression((SqmExpression)sqmQuerySpec.getOffsetExpression());
        Object fetchExpression = this.visitFetchExpression((SqmExpression)sqmQuerySpec.getFetchExpression());
        sqlQuerySpec.setOffsetClauseExpression((Expression)offsetExpression);
        sqlQuerySpec.setFetchClauseExpression((Expression)fetchExpression, sqmQuerySpec.getFetchClauseType());
        return sqlQuerySpec;
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitFetchExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.FETCH);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(this::consumeFromClauseRoot);
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    protected void consumeFromClauseRoot(SqmRoot<?> sqmRoot) {
        TableGroup tableGroup;
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        if (fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        SqlExpressionResolver sqlExpressionResolver = this.getSqlExpressionResolver();
        if (sqmRoot.isCorrelated()) {
            SessionFactoryImplementor sessionFactory = this.creationContext.getSessionFactory();
            TableGroup parentTableGroup = fromClauseIndex.findTableGroup(sqmRoot.getCorrelationParent().getNavigablePath());
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            if (sqmRoot.containsOnlyInnerJoins()) {
                SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
                CorrelatedTableGroup tableGroup2 = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, this.currentQuerySpec(), predicate -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                }, sessionFactory);
                log.tracef("Resolved SqmRoot [%s] to correlated TableGroup [%s]", sqmRoot, (Object)tableGroup2);
                this.consumeExplicitJoins(sqmRoot, tableGroup2);
                this.consumeReusablePaths(sqmRoot, tableGroup2);
                return;
            }
            tableGroup = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), LockMode.NONE, () -> predicate -> {}, this, this.creationContext);
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            NavigablePath navigablePath = sqmRoot.getNavigablePath().append(identifierMapping.getNavigableRole().getNavigableName());
            int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
            if (jdbcTypeCount == 1) {
                identifierMapping.forEachSelectable((index, selectable) -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new ColumnReference(parentTableGroup.getTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory), ComparisonOperator.EQUAL, new ColumnReference(tableGroup.getTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory)));
                });
            } else {
                ArrayList lhs = new ArrayList(jdbcTypeCount);
                ArrayList rhs = new ArrayList(jdbcTypeCount);
                identifierMapping.forEachSelectable((index, selectable) -> {
                    lhs.add(new ColumnReference(parentTableGroup.getTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory));
                    rhs.add(new ColumnReference(tableGroup.getTableReference(navigablePath, selectable.getContainingTableExpression()), selectable, sessionFactory));
                });
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new SqlTuple(lhs, identifierMapping), ComparisonOperator.EQUAL, new SqlTuple(rhs, identifierMapping)));
            }
        } else {
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            tableGroup = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), LockMode.NONE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.creationContext);
        }
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        fromClauseIndex.register(sqmRoot, tableGroup);
        this.currentQuerySpec().getFromClause().addRoot(tableGroup);
        this.consumeExplicitJoins(sqmRoot, tableGroup);
        this.consumeReusablePaths(sqmRoot, tableGroup);
    }

    private EntityPersister resolveEntityPersister(EntityDomainType<?> entityDomainType) {
        return this.creationContext.getDomainModel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
    }

    protected void consumeExplicitJoins(SqmFrom<?, ?> sqmFrom, TableGroup lhsTableGroup) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting explicit joins for `%s`", (Object)sqmFrom.getNavigablePath());
        }
        sqmFrom.visitSqmJoins(sqmJoin -> this.consumeExplicitJoin((SqmJoin<?, ?>)sqmJoin, lhsTableGroup));
    }

    protected void consumeExplicitJoin(SqmJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        if (sqmJoin instanceof SqmAttributeJoin) {
            this.consumeAttributeJoin((SqmAttributeJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmCrossJoin) {
            this.consumeCrossJoin((SqmCrossJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmEntityJoin) {
            this.consumeEntityJoin((SqmEntityJoin)sqmJoin, lhsTableGroup);
        } else {
            throw new InterpretationException("Could not resolve SqmJoin [" + sqmJoin.getNavigablePath() + "] to TableGroupJoin");
        }
    }

    private void consumeAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        TableGroupJoin joinedTableGroupJoin;
        NavigablePath joinPath;
        SqmPathSource<?> pathSource = sqmJoin.getReferencedPathSource();
        NavigablePath sqmJoinNavigablePath = sqmJoin.getNavigablePath();
        NavigablePath parentNavigablePath = sqmJoinNavigablePath.getParent();
        ModelPart modelPart = lhsTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
        if (pathSource instanceof PluralPersistentAttribute) {
            assert (modelPart instanceof PluralAttributeMapping);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            joinPath = this.getJoinNavigablePath(sqmJoinNavigablePath, parentNavigablePath, pluralAttributeMapping.getPartName());
            this.joinPathBySqmJoinFullPath.put(sqmJoin.getNavigablePath().getFullPath(), joinPath.append(CollectionPart.Nature.ELEMENT.getName()));
            joinedTableGroupJoin = pluralAttributeMapping.createTableGroupJoin(joinPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), sqmJoin.isFetched(), this.determineLockMode(sqmJoin.getExplicitAlias()), this);
        } else {
            assert (modelPart instanceof TableGroupJoinProducer);
            joinPath = this.getJoinNavigablePath(sqmJoinNavigablePath, parentNavigablePath, modelPart.getPartName());
            joinedTableGroupJoin = ((TableGroupJoinProducer)modelPart).createTableGroupJoin(joinPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), sqmJoin.isFetched(), this.determineLockMode(sqmJoin.getExplicitAlias()), this);
        }
        TableGroup joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
        lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, joinedTableGroup, joinPath);
        if (sqmJoin.getJoinPredicate() != null) {
            if (sqmJoin.isFetched()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.debugf("Join fetch [" + sqmJoinNavigablePath + "] is restricted", new Object[0]);
            }
            if (joinedTableGroupJoin == null) {
                throw new IllegalStateException();
            }
            joinedTableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
        this.consumeExplicitJoins(sqmJoin, joinedTableGroup);
        this.consumeReusablePaths(sqmJoin, joinedTableGroup);
    }

    private NavigablePath getJoinNavigablePath(NavigablePath sqmJoinNavigablePath, NavigablePath parentNavigablePath, String partName) {
        if (parentNavigablePath == null) {
            return sqmJoinNavigablePath;
        }
        NavigablePath elementNavigablePath = this.joinPathBySqmJoinFullPath.get(parentNavigablePath.getFullPath());
        if (elementNavigablePath == null) {
            return sqmJoinNavigablePath;
        }
        return elementNavigablePath.append(partName);
    }

    private void consumeCrossJoin(SqmCrossJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), this.determineLockMode(sqmJoin.getExplicitAlias()), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), SqlAstJoinType.CROSS, tableGroup);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeReusablePaths(sqmJoin, tableGroupJoin.getJoinedGroup());
    }

    private void consumeEntityJoin(SqmEntityJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), this.determineLockMode(sqmJoin.getExplicitAlias()), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), tableGroup, null);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeReusablePaths(sqmJoin, tableGroupJoin.getJoinedGroup());
        if (sqmJoin.getJoinPredicate() != null) {
            tableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
    }

    private void consumeReusablePaths(SqmPath<?> sqmPath, TableGroup tableGroup) {
        this.consumeReusablePaths(sqmPath, tableGroup, sqmSubPath -> {});
    }

    private void consumeReusablePaths(SqmPath<?> sqmPath, TableGroup parentTableGroup, Consumer<SqmPath<?>> implicitJoinChecker) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting implicit joins for `%s`", (Object)sqmPath.getNavigablePath());
        }
        sqmPath.visitReusablePaths(joinedPath -> {
            TableGroup tableGroup;
            if (log.isTraceEnabled()) {
                log.tracef("Starting implicit join handling for `%s`", (Object)joinedPath.getNavigablePath());
            }
            if (joinedPath.getReusablePaths().isEmpty()) {
                return;
            }
            JpaPath lhsPath = joinedPath.getLhs();
            FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
            ModelPart subPart = parentTableGroup.getModelPart().findSubPart(joinedPath.getReferencedPathSource().getPathName(), lhsPath instanceof SqmTreatedPath ? this.resolveEntityPersister(((SqmTreatedPath)lhsPath).getTreatTarget()) : null);
            if (subPart instanceof TableGroupJoinProducer) {
                implicitJoinChecker.accept((SqmPath<?>)joinedPath);
                TableGroupJoinProducer joinProducer = (TableGroupJoinProducer)subPart;
                TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(joinedPath.getNavigablePath(), parentTableGroup, null, parentTableGroup.isInnerJoinPossible() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT, false, null, this);
                fromClauseIndex.register((SqmPath<?>)joinedPath, tableGroupJoin.getJoinedGroup());
                tableGroup = tableGroupJoin.getJoinedGroup();
            } else {
                tableGroup = null;
            }
            this.consumeReusablePaths((SqmPath<?>)joinedPath, tableGroup, implicitJoinChecker);
        });
    }

    @Override
    public TableGroup visitRootPath(SqmRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return resolved;
        }
        throw new InterpretationException("SqmRoot not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmAttributeJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmAttributeJoin not yet resolved to TableGroup");
    }

    private QuerySpec currentQuerySpec() {
        return this.currentQueryPart().getLastQuerySpec();
    }

    private QueryPart currentQueryPart() {
        SqlAstQueryPartProcessingState processingState = (SqlAstQueryPartProcessingState)this.getProcessingStateStack().getCurrent();
        return processingState.getInflightQueryPart();
    }

    protected SqmAliasedNodeCollector currentSqlSelectionCollector() {
        return (SqmAliasedNodeCollector)((Object)this.getCurrentProcessingState().getSqlExpressionResolver());
    }

    @Override
    public TableGroup visitCrossJoin(SqmCrossJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCrossJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmCrossJoin not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedEntityJoin(SqmEntityJoin sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmEntityJoin [%s] resolved to existing TableGroup [%s]", (Object)sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmEntityJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitBasicValuedPath(SqmBasicValuedSimplePath<?> sqmPath) {
        BasicValuedPathInterpretation<?> path = BasicValuedPathInterpretation.from(sqmPath, this, this);
        if (TypeConfiguration.isDuration(sqmPath.getNodeType())) {
            Expression scaledExpression = this.applyScale(this.toSqlExpression(path));
            if (this.adjustedTimestamp != null) {
                if (this.appliedByUnit != null) {
                    throw new IllegalStateException();
                }
                return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, new DurationUnit(TemporalUnit.NANOSECOND, this.basicType(Long.class)), scaledExpression, this.adjustedTimestamp);
            }
            if (this.appliedByUnit != null) {
                JdbcMappingContainer durationType = scaledExpression.getExpressionType();
                Duration duration = new Duration(scaledExpression, TemporalUnit.NANOSECOND, (BasicValuedMapping)durationType);
                TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
                BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
                return new Conversion(duration, appliedUnit, scalarType);
            }
            return scaledExpression;
        }
        return path;
    }

    @Override
    public SqmPathInterpretation<?> visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> sqmPath) {
        return EmbeddableValuedPathInterpretation.from(sqmPath, this, this);
    }

    @Override
    public SqmPathInterpretation visitAnyValuedValuedPath(SqmAnyValuedSimplePath<?> path) {
        return DiscriminatedAssociationPathInterpretation.from(path, this);
    }

    @Override
    public Object visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath sqmPath) {
        return NonAggregatedCompositeValuedPathInterpretation.from(sqmPath, this, this);
    }

    @Override
    public SqmPathInterpretation<?> visitEntityValuedPath(SqmEntityValuedSimplePath sqmPath) {
        return EntityValuedPathInterpretation.from(sqmPath, this);
    }

    @Override
    public SqmPathInterpretation<?> visitPluralValuedPath(SqmPluralValuedSimplePath sqmPath) {
        return PluralValuedSimplePathInterpretation.from(sqmPath, this);
    }

    @Override
    public Expression visitLiteral(SqmLiteral<?> literal) {
        ConvertibleModelPart convertibleModelPart;
        BasicValueConverter valueConverter;
        Supplier<MappingModelExpressable> inferableTypeAccess = this.inferrableTypeAccessStack.getCurrent();
        if (literal instanceof SqmLiteralNull) {
            MappingModelExpressable mappingModelExpressable = inferableTypeAccess.get();
            if (mappingModelExpressable instanceof BasicValuedMapping) {
                return new NullnessLiteral(mappingModelExpressable);
            }
            MappingModelExpressable<?> keyExpressable = this.getKeyExpressable(mappingModelExpressable);
            if (keyExpressable == null) {
                throw new IllegalArgumentException("Could not determine type for null literal");
            }
            ArrayList expressions = new ArrayList(keyExpressable.getJdbcTypeCount());
            keyExpressable.forEachJdbcType((index, jdbcMapping) -> expressions.add(new QueryLiteral<Object>(null, (BasicValuedMapping)((Object)jdbcMapping))));
            return new SqlTuple(expressions, mappingModelExpressable);
        }
        MappingModelExpressable inferableExpressable = inferableTypeAccess.get();
        if (inferableExpressable instanceof ConvertibleModelPart && (valueConverter = (convertibleModelPart = (ConvertibleModelPart)inferableExpressable).getValueConverter()) != null) {
            Object sqlLiteralValue;
            Object literalValue = literal.getLiteralValue();
            if (valueConverter.getDomainJavaDescriptor().getJavaTypeClass().isInstance(literalValue)) {
                sqlLiteralValue = valueConverter.toRelationalValue(literalValue);
            } else {
                if (!valueConverter.getRelationalJavaDescriptor().getJavaTypeClass().isInstance(literalValue)) {
                    throw new SqlTreeCreationException(String.format(Locale.ROOT, "QueryLiteral type [`%s`] did not match domain Java-type [`%s`] nor JDBC Java-type [`%s`]", literalValue.getClass(), valueConverter.getDomainJavaDescriptor().getJavaTypeClass().getName(), valueConverter.getRelationalJavaDescriptor().getJavaTypeClass().getName()));
                }
                sqlLiteralValue = literalValue;
            }
            return new QueryLiteral(sqlLiteralValue, (BasicValuedMapping)inferableExpressable);
        }
        BasicType<?> localExpressable = SqmMappingModelHelper.resolveMappingModelExpressable(literal, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup);
        BasicType<?> expressable = localExpressable instanceof BasicType ? InferredBasicValueResolver.resolveSqlTypeIndicators(this, localExpressable, literal.getJavaTypeDescriptor()) : localExpressable;
        return new QueryLiteral(literal.getLiteralValue(), expressable);
    }

    private MappingModelExpressable<?> getKeyExpressable(JdbcMappingContainer mappingModelExpressable) {
        if (mappingModelExpressable instanceof EntityAssociationMapping) {
            return ((EntityAssociationMapping)mappingModelExpressable).getKeyTargetMatchPart();
        }
        return (MappingModelExpressable)mappingModelExpressable;
    }

    @Override
    public Map<SqmParameter, List<List<JdbcParameter>>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, (index, jdbcParameter) -> {
            jdbcParameterConsumer.accept((Integer)index, (JdbcParameter)jdbcParameter);
            jdbcParametersForSqm.add((JdbcParameter)jdbcParameter);
        });
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        binding.setType(valueMapping);
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, jdbcParametersForSqm::add);
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        binding.setType(valueMapping);
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    protected MappingModelExpressable<?> lenientlyResolveMappingExpressable(SqmExpressable<?> nodeType) {
        try {
            return this.resolveMappingExpressable(nodeType);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    protected MappingModelExpressable<?> resolveMappingExpressable(SqmExpressable<?> nodeType) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType, this::findTableGroupByPath);
        if (valueMapping == null && (currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpressable: " + nodeType);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmExpression<?> sqmExpression) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        SqmSelection subQuerySelection;
        SqmPathSource selectionNodeType;
        SqmSubQuery subQuery;
        SqmSelectClause selectClause;
        Supplier<MappingModelExpressable> currentExpressableSupplier2;
        if (sqmExpression instanceof SqmParameter) {
            return this.determineValueMapping((SqmParameter)sqmExpression);
        }
        MappingMetamodel domainModel = this.getCreationContext().getDomainModel();
        if (sqmExpression instanceof SqmPath) {
            log.debugf("Determining mapping-model type for SqmPath : %s ", sqmExpression);
            return SqmMappingModelHelper.resolveMappingModelExpressable(sqmExpression, domainModel, this.getFromClauseAccess()::findTableGroup);
        }
        if (sqmExpression instanceof SqmEnumLiteral && (currentExpressableSupplier2 = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier2.get();
        }
        if (sqmExpression instanceof SqmSubQuery && (selectClause = ((SqmQuerySpec)(subQuery = (SqmSubQuery)sqmExpression).getQuerySpec()).getSelectClause()).getSelections().size() == 1 && (selectionNodeType = (subQuerySelection = selectClause.getSelections().get(0)).getNodeType()) != null) {
            SqmPathSource sqmExpressable = selectionNodeType instanceof PluralPersistentAttribute ? ((PluralPersistentAttribute)selectionNodeType).getElementPathSource() : selectionNodeType;
            MappingModelExpressable expressable = domainModel.resolveMappingExpressable(sqmExpressable, this::findTableGroupByPath);
            if (expressable != null) {
                return expressable;
            }
            try {
                return this.inferrableTypeAccessStack.getCurrent().get();
            }
            catch (Exception ignore) {
                return null;
            }
        }
        log.debugf("Determining mapping-model type for generalized SqmExpression : %s", sqmExpression);
        SqmExpressable<?> nodeType = sqmExpression.getNodeType();
        MappingModelExpressable valueMapping = domainModel.resolveMappingExpressable(nodeType, this::findTableGroupByPath);
        if (valueMapping == null && (currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpression: " + sqmExpression);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmParameter<?> sqmParameter) {
        MappingModelExpressable inferredMapping;
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        log.debugf("Determining mapping-model type for SqmParameter : %s", sqmParameter);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (sqmParameter.getAnticipatedType() == null && (currentExpressableSupplier = this.inferrableTypeAccessStack.getCurrent()) != null && (inferredMapping = currentExpressableSupplier.get()) != null) {
            if (inferredMapping instanceof PluralAttributeMapping) {
                return ((PluralAttributeMapping)inferredMapping).getElementDescriptor();
            }
            return inferredMapping;
        }
        AllowableParameterType<Object> parameterSqmType = binding.getBindType();
        if (parameterSqmType == null && (parameterSqmType = queryParameter.getHibernateType()) == null) {
            parameterSqmType = sqmParameter.getAnticipatedType();
        }
        assert (parameterSqmType != null);
        if (parameterSqmType instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)((Object)parameterSqmType);
            NavigablePath navigablePath = sqmPath.getNavigablePath();
            if (navigablePath.getParent() != null) {
                TableGroup tableGroup = this.getFromClauseAccess().getTableGroup(navigablePath.getParent());
                return tableGroup.getModelPart().findSubPart(navigablePath.getLocalName(), null);
            }
            return this.getFromClauseAccess().getTableGroup(navigablePath).getModelPart();
        }
        if (parameterSqmType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)parameterSqmType);
        }
        if (parameterSqmType instanceof CompositeSqmPathSource) {
            throw new NotYetImplementedFor6Exception("Support for embedded-valued parameters not yet implemented");
        }
        throw new ConversionException("Could not determine ValueMapping for SqmParameter: " + sqmParameter);
    }

    private void resolveSqmParameter(SqmParameter expression, MappingModelExpressable valueMapping, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        this.sqmParameterMappingModelTypes.put(expression, valueMapping);
        if (valueMapping instanceof Association) {
            ((Association)valueMapping).getForeignKeyDescriptor().forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(index, new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
        } else {
            valueMapping.forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(index, new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
        }
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        if (this.jpaCriteriaParamResolutions == null) {
            throw new IllegalStateException("No JpaCriteriaParameter resolutions registered");
        }
        Supplier<SqmJpaCriteriaParameterWrapper<?>> supplier = this.jpaCriteriaParamResolutions.get(expression);
        if (supplier == null) {
            throw new IllegalStateException("Criteria parameter [" + expression + "] not known to be a parameter of the processing tree");
        }
        return this.consumeSqmParameter(supplier.get());
    }

    @Override
    public Object visitTuple(SqmTuple<?> sqmTuple) {
        List<SqmExpression<?>> groupedExpressions = sqmTuple.getGroupedExpressions();
        int size = groupedExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupedExpressions.get(i).accept(this));
        }
        return new SqlTuple(expressions, null);
    }

    @Override
    public Object visitCollate(SqmCollate<?> sqmCollate) {
        return new Collate((Expression)sqmCollate.getExpression().accept(this), sqmCollate.getCollation());
    }

    @Override
    public Expression visitFunction(SqmFunction sqmFunction) {
        this.inferrableTypeAccessStack.push(() -> null);
        try {
            Expression expression = sqmFunction.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public Star visitStar(SqmStar sqmStar) {
        return new Star();
    }

    @Override
    public Object visitMapEntryFunction(SqmMapEntryReference entryRef) {
        SqmPath<?> mapPath = entryRef.getMapPath();
        NavigablePath mapNavigablePath = mapPath.getNavigablePath();
        TableGroup tableGroup = this.getFromClauseAccess().resolveTableGroup(mapNavigablePath, navigablePath -> {
            TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(mapNavigablePath.getParent());
            PluralAttributeMapping mapAttribute = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(mapNavigablePath.getLocalName(), null);
            TableGroupJoin tableGroupJoin = mapAttribute.createTableGroupJoin(mapNavigablePath, parentTableGroup, null, SqlAstJoinType.INNER, false, LockMode.READ, this.sqlAliasBaseManager, this.getSqlExpressionResolver(), this.creationContext);
            return tableGroupJoin.getJoinedGroup();
        });
        PluralAttributeMapping mapDescriptor = (PluralAttributeMapping)tableGroup.getModelPart();
        ForeignKeyDescriptor keyDescriptor = mapDescriptor.getKeyDescriptor();
        NavigablePath keyNavigablePath = mapNavigablePath.append(keyDescriptor.getPartName());
        final DomainResult<?> keyResult = keyDescriptor.createKeyDomainResult(keyNavigablePath, tableGroup, this);
        CollectionPart valueDescriptor = mapDescriptor.getElementDescriptor();
        NavigablePath valueNavigablePath = mapNavigablePath.append(valueDescriptor.getPartName());
        final DomainResult valueResult = valueDescriptor.createDomainResult(valueNavigablePath, tableGroup, null, this);
        return new DomainResultProducer(){

            public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
                JavaTypeDescriptor mapEntryDescriptor = BaseSqmToSqlAstConverter.this.getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor((Type)((Object)Map.Entry.class));
                return new SqmMapEntryResult(keyResult, valueResult, resultVariable, mapEntryDescriptor);
            }
        };
    }

    @Override
    public Object visitDistinct(SqmDistinct sqmDistinct) {
        return new Distinct((Expression)sqmDistinct.getExpression().accept(this));
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification specification) {
        return new TrimSpecification(specification.getSpecification());
    }

    @Override
    public Object visitCastTarget(SqmCastTarget target) {
        BasicType<?> targetType = (BasicType<?>)target.getType();
        if (targetType instanceof BasicType) {
            targetType = InferredBasicValueResolver.resolveSqlTypeIndicators(this, targetType, target.getNodeJavaTypeDescriptor());
        }
        return new CastTarget(targetType.getJdbcMapping(), target.getLength(), target.getPrecision(), target.getScale());
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit unit) {
        return new ExtractUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit unit) {
        return new DurationUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return new Format((String)sqmFormat.getLiteralValue(), (BasicValuedMapping)((Object)sqmFormat.getNodeType()));
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        return new UnaryOperation(this.interpret(expression.getOperation()), this.toSqlExpression(expression.getOperand().accept(this)), (BasicValuedMapping)this.determineValueMapping(expression.getOperand()));
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        boolean temporalTypeSomewhereToLeft;
        SqmExpression leftOperand = expression.getLeftHandOperand();
        SqmExpression rightOperand = expression.getRightHandOperand();
        boolean durationToRight = TypeConfiguration.isDuration(rightOperand.getNodeType());
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType temporalTypeToLeft = typeConfiguration.getSqlTemporalType(leftOperand.getNodeType());
        TemporalType temporalTypeToRight = typeConfiguration.getSqlTemporalType(rightOperand.getNodeType());
        boolean bl = temporalTypeSomewhereToLeft = this.adjustedTimestamp != null || temporalTypeToLeft != null;
        if (temporalTypeToLeft != null && durationToRight && (this.adjustmentScale != null || this.negativeAdjustment)) {
            throw new SemanticException("scalar multiplication of temporal value");
        }
        if (durationToRight && temporalTypeSomewhereToLeft) {
            return this.transformDurationArithmetic(expression);
        }
        if (temporalTypeToLeft != null && temporalTypeToRight != null) {
            return this.transformDatetimeArithmetic(expression);
        }
        if (durationToRight && this.appliedByUnit != null) {
            return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType()));
        }
        return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), this.getExpressionType(expression));
    }

    private BasicValuedMapping getExpressionType(SqmBinaryArithmetic expression) {
        SqmExpressable leftHandOperandType = expression.getLeftHandOperand().getNodeType();
        if (leftHandOperandType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)leftHandOperandType);
        }
        return (BasicValuedMapping)((Object)expression.getRightHandOperand().getNodeType());
    }

    private Expression toSqlExpression(Object value) {
        return (Expression)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object transformDurationArithmetic(SqmBinaryArithmetic<?> expression) {
        operator = expression.getOperator();
        switch (4.$SwitchMap$org$hibernate$query$BinaryArithmeticOperator[operator.ordinal()]) {
            case 1: 
            case 2: {
                timestamp = this.adjustedTimestamp;
                timestampType = this.adjustedTimestampType;
                this.adjustedTimestamp = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                type = this.adjustedTimestamp.getExpressionType();
                this.adjustedTimestampType = type instanceof SqmExpressable != false ? (SqmExpressable<Object>)type : (type instanceof AttributeMapping != false ? (SqmExpressable<Object>)((AttributeMapping)type).getMappedType() : expression.getLeftHandOperand().getNodeType());
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                try {
                    var6_6 = expression.getRightHandOperand().accept(this);
                    if (operator != BinaryArithmeticOperator.SUBTRACT) ** GOTO lbl21
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                catch (Throwable var7_8) {
                    if (operator == BinaryArithmeticOperator.SUBTRACT) {
                        this.negativeAdjustment = this.negativeAdjustment == false;
                    }
                    this.adjustedTimestamp = timestamp;
                    this.adjustedTimestampType = timestampType;
                    throw var7_8;
                }
lbl21:
                // 2 sources

                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var6_6;
            }
            case 3: {
                duration = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                scale = this.adjustmentScale;
                negate = this.negativeAdjustment;
                this.adjustmentScale = this.applyScale(duration);
                this.negativeAdjustment = false;
                try {
                    var9_11 = expression.getRightHandOperand().accept(this);
                    return var9_11;
                }
                finally {
                    this.adjustmentScale = scale;
                    this.negativeAdjustment = negate;
                }
            }
        }
        throw new SemanticException("illegal operator for a duration " + (Object)operator);
    }

    private Object transformDatetimeArithmetic(SqmBinaryArithmetic expression) {
        TemporalUnit baseUnit;
        BinaryArithmeticOperator operator = expression.getOperator();
        if (operator != BinaryArithmeticOperator.SUBTRACT) {
            throw new SemanticException("illegal operator for temporal type: " + (Object)((Object)operator));
        }
        Expression left = this.cleanly(() -> this.toSqlExpression(expression.getLeftHandOperand().accept(this)));
        Expression right = this.cleanly(() -> this.toSqlExpression(expression.getRightHandOperand().accept(this)));
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType leftTimestamp = typeConfiguration.getSqlTemporalType(expression.getLeftHandOperand().getNodeType());
        TemporalType rightTimestamp = typeConfiguration.getSqlTemporalType(expression.getRightHandOperand().getNodeType());
        TemporalUnit temporalUnit = baseUnit = rightTimestamp == TemporalType.TIMESTAMP || leftTimestamp == TemporalType.TIMESTAMP ? TemporalUnit.NATIVE : TemporalUnit.DAY;
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
            Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        if (this.appliedByUnit != null) {
            DurationUnit unit = (DurationUnit)this.appliedByUnit.getUnit().accept((SemanticQueryWalker<?>)this);
            return this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        }
        DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
        Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        return new Duration(scaledMagnitude, baseUnit, durationType);
    }

    private <J> BasicValuedMapping basicType(Class<J> javaType) {
        return this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(javaType);
    }

    private TimestampaddFunction timestampadd() {
        return (TimestampaddFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd");
    }

    private TimestampdiffFunction timestampdiff() {
        return (TimestampdiffFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampdiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T cleanly(Supplier<T> supplier) {
        SqmByUnit byUnit = this.appliedByUnit;
        Expression timestamp = this.adjustedTimestamp;
        SqmExpressable<?> timestampType = this.adjustedTimestampType;
        Expression scale = this.adjustmentScale;
        boolean negate = this.negativeAdjustment;
        this.adjustmentScale = null;
        this.negativeAdjustment = false;
        this.appliedByUnit = null;
        this.adjustedTimestamp = null;
        this.adjustedTimestampType = null;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.appliedByUnit = byUnit;
            this.adjustedTimestamp = timestamp;
            this.adjustedTimestampType = timestampType;
            this.adjustmentScale = scale;
            this.negativeAdjustment = negate;
        }
    }

    Expression applyScale(Expression magnitude) {
        boolean negate = this.negativeAdjustment;
        if (magnitude instanceof UnaryOperation) {
            UnaryOperation unary = (UnaryOperation)magnitude;
            if (unary.getOperator() == UnaryArithmeticOperator.UNARY_MINUS) {
                negate = !negate;
            }
            magnitude = unary.getOperand();
        }
        if (this.adjustmentScale != null && !BaseSqmToSqlAstConverter.isOne(this.adjustmentScale)) {
            magnitude = BaseSqmToSqlAstConverter.isOne(magnitude) ? this.adjustmentScale : new BinaryArithmeticExpression(this.adjustmentScale, BinaryArithmeticOperator.MULTIPLY, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        if (negate) {
            magnitude = new UnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        return magnitude;
    }

    static boolean isOne(Expression scale) {
        return scale instanceof QueryLiteral && ((Number)((QueryLiteral)scale).getLiteralValue()).longValue() == 1L;
    }

    @Override
    public Object visitToDuration(SqmToDuration toDuration) {
        Expression magnitude = this.toSqlExpression(toDuration.getMagnitude().accept(this));
        DurationUnit unit = (DurationUnit)toDuration.getUnit().accept((SemanticQueryWalker<?>)this);
        Expression scaledMagnitude = this.applyScale(magnitude);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)toDuration.getNodeType());
        Duration duration = new Duration(scaledMagnitude, unit.getUnit(), durationType);
        if (this.appliedByUnit != null) {
            TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
            BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
            return new Conversion(duration, appliedUnit, scalarType);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitByUnit(SqmByUnit byUnit) {
        SqmByUnit outer = this.appliedByUnit;
        this.appliedByUnit = byUnit;
        try {
            Object object = byUnit.getDuration().accept(this);
            return object;
        }
        finally {
            this.appliedByUnit = outer;
        }
    }

    @Override
    public QueryPart visitSubQueryExpression(SqmSubQuery sqmSubQuery) {
        return this.visitQueryPart((SqmQueryPart)sqmSubQuery.getQueryPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        MappingModelExpressable alreadyKnown;
        ArrayList<CaseSimpleExpression.WhenFragment> whenFragments = new ArrayList<CaseSimpleExpression.WhenFragment>(expression.getWhenFragments().size());
        MappingModelExpressable resolved = alreadyKnown = this.determineCurrentExpressable(expression);
        this.inferrableTypeAccessStack.push(() -> alreadyKnown);
        Expression otherwise = null;
        try {
            for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
                Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
                resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, resultExpression.getExpressionType());
                whenFragments.add(new CaseSimpleExpression.WhenFragment((Expression)whenFragment.getCheckValue().accept(this), resultExpression));
            }
            if (expression.getOtherwise() != null) {
                otherwise = (Expression)expression.getOtherwise().accept(this);
                resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, otherwise.getExpressionType());
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new CaseSimpleExpression(resolved, (Expression)expression.getFixture().accept(this), whenFragments, otherwise);
    }

    private MappingModelExpressable<?> determineCurrentExpressable(SqmTypedNode<?> expression) {
        try {
            return this.creationContext.getDomainModel().resolveMappingExpressable(expression.getNodeType(), this.getFromClauseIndex()::findTableGroup);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        MappingModelExpressable alreadyKnown;
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(expression.getWhenFragments().size());
        MappingModelExpressable resolved = alreadyKnown = this.determineCurrentExpressable(expression);
        this.inferrableTypeAccessStack.push(() -> alreadyKnown);
        Expression otherwise = null;
        try {
            for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
                Predicate whenPredicate = (Predicate)whenFragment.getPredicate().accept(this);
                Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
                resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, resultExpression.getExpressionType());
                whenFragments.add(new CaseSearchedExpression.WhenFragment(whenPredicate, resultExpression));
            }
            if (expression.getOtherwise() != null) {
                otherwise = (Expression)expression.getOtherwise().accept(this);
                resolved = (MappingModelExpressable)TypeHelper.highestPrecedence(resolved, otherwise.getExpressionType());
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new CaseSearchedExpression(resolved, whenFragments, otherwise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X visitWithInferredType(SqmExpression<?> expression, SqmExpression<?> inferred) {
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(inferred));
        try {
            Object object = expression.accept(this);
            return (X)object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X visitWithLenientInferredType(SqmExpression<?> expression, SqmExpression<?> inferred) {
        this.inferrableTypeAccessStack.push(() -> {
            MappingModelExpressable definedType2;
            try {
                definedType2 = this.creationContext.getDomainModel().resolveMappingExpressable(expression.getNodeType(), this.getFromClauseIndex()::findTableGroup);
                if (definedType2 != null) {
                    return definedType2;
                }
            }
            catch (UnsupportedOperationException definedType2) {
                // empty catch block
            }
            try {
                definedType2 = this.creationContext.getDomainModel().lenientlyResolveMappingExpressable(inferred.getNodeType(), this.getFromClauseIndex()::findTableGroup);
                if (definedType2 != null) {
                    return definedType2;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return null;
        });
        try {
            Object object = expression.accept(this);
            return (X)object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return new Any(this.visitSubQueryExpression((SqmSubQuery)sqmAny.getSubquery()), null);
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return new Every(this.visitSubQueryExpression((SqmSubQuery)sqmEvery.getSubquery()), null);
    }

    @Override
    public Object visitSummarization(SqmSummarization<?> sqmSummarization) {
        List<SqmExpression<?>> groupingExpressions = sqmSummarization.getGroupings();
        int size = groupingExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupingExpressions.get(i).accept(this));
        }
        return new Summarization(this.getSummarizationKind(sqmSummarization.getKind()), expressions);
    }

    private Summarization.Kind getSummarizationKind(SqmSummarization.Kind kind) {
        switch (kind) {
            case CUBE: {
                return Summarization.Kind.CUBE;
            }
            case ROLLUP: {
                return Summarization.Kind.ROLLUP;
            }
        }
        throw new UnsupportedOperationException("Unsupported summarization: " + (Object)((Object)kind));
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType sqmExpression) {
        SqmExpressable nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitParameterizedEntityTypeExpression(SqmParameterizedEntityType<?> sqmExpression) {
        assert (this.inferrableTypeAccessStack.getCurrent().get() instanceof EntityDiscriminatorMapping);
        return (Expression)sqmExpression.getDiscriminatorSource().accept(this);
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral sqmEnumLiteral) {
        BasicValuedMapping inferrableType = (BasicValuedMapping)this.inferrableTypeAccessStack.getCurrent().get();
        if (inferrableType instanceof ConvertibleModelPart) {
            ConvertibleModelPart inferredPart = (ConvertibleModelPart)inferrableType;
            BasicValueConverter valueConverter = inferredPart.getValueConverter();
            Object jdbcValue = valueConverter.toRelationalValue(sqmEnumLiteral.getEnumValue());
            return new QueryLiteral(jdbcValue, inferredPart);
        }
        return new QueryLiteral<Enum>(sqmEnumLiteral.getEnumValue(), (BasicValuedMapping)this.determineValueMapping(sqmEnumLiteral));
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral sqmFieldLiteral) {
        return new QueryLiteral(sqmFieldLiteral.getValue(), (BasicValuedMapping)this.determineValueMapping(sqmFieldLiteral));
    }

    @Override
    public Expression visitMaxElementPath(SqmMaxElementPath<?> path) {
        return this.createCorrelatedAggregateSubQuery(path, false, true);
    }

    @Override
    public Expression visitMinElementPath(SqmMinElementPath<?> path) {
        return this.createCorrelatedAggregateSubQuery(path, false, false);
    }

    @Override
    public Expression visitMaxIndexPath(SqmMaxIndexPath<?> path) {
        return this.createCorrelatedAggregateSubQuery(path, true, true);
    }

    @Override
    public Expression visitMinIndexPath(SqmMinIndexPath<?> path) {
        return this.createCorrelatedAggregateSubQuery(path, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        SqmPath pluralPath = function.getPluralPath();
        TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(pluralPath.getNavigablePath().getParent());
        assert (parentTableGroup != null);
        PluralAttributeMapping collectionPart = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(pluralPath.getNavigablePath().getUnaliasedLocalName(), null);
        assert (collectionPart != null);
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = collectionPart.createRootTableGroup(pluralPath.getNavigablePath(), null, LockOptions.NONE.getLockMode(), () -> subQuerySpec::applyPredicate, this, this.creationContext);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = (AbstractSqmSelfRenderingFunctionDescriptor)this.creationContext.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("count");
            BasicType<Integer> integerType = this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
            SelfRenderingFunctionSqlAstExpression expression = new SelfRenderingFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor::render, Collections.singletonList(new QueryLiteral<Integer>(1, integerType)), integerType, integerType);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, expression));
            subQuerySpec.applyPredicate(collectionPart.getKeyDescriptor().generateJoinPredicate(parentTableGroup, tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return subQuerySpec;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath path) {
        return path.getLhs().accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createCorrelatedAggregateSubQuery(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, boolean max) {
        PluralAttributeMapping mappingModelExpressable = (PluralAttributeMapping)this.determineValueMapping(pluralPartPath.getPluralDomainPath());
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = mappingModelExpressable.createRootTableGroup(pluralPartPath.getNavigablePath(), null, LockOptions.NONE.getLockMode(), () -> subQuerySpec::applyPredicate, this, this.creationContext);
            this.getFromClauseAccess().registerTableGroup(pluralPartPath.getNavigablePath(), tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = (AbstractSqmSelfRenderingFunctionDescriptor)this.creationContext.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(max ? "max" : "min");
            CollectionPart collectionPart = index ? mappingModelExpressable.getIndexDescriptor() : mappingModelExpressable.getElementDescriptor();
            ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(1);
            NavigablePath navigablePath = pluralPartPath.getNavigablePath();
            collectionPart.forEachSelectable((selectionIndex, selectionMapping) -> arguments.add(new ColumnReference(tableGroup.getTableReference(navigablePath, selectionMapping.getContainingTableExpression()), selectionMapping, this.creationContext.getSessionFactory())));
            SelfRenderingFunctionSqlAstExpression expression = new SelfRenderingFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor::render, arguments, (AllowableFunctionReturnType)((Object)collectionPart.getJdbcMappings().get(0)), collectionPart);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, expression));
            subQuerySpec.applyPredicate(mappingModelExpressable.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPartPath.getPluralDomainPath().getNavigablePath().getParent()), tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return subQuerySpec;
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    @Override
    public Junction visitAndPredicate(SqmAndPredicate predicate) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        conjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        conjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return conjunction;
    }

    @Override
    public Junction visitOrPredicate(SqmOrPredicate predicate) {
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION);
        disjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        disjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return disjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        Expression lhs;
        SqmPath<?> pluralPath = predicate.getPluralPath();
        PluralAttributeMapping mappingModelExpressable = (PluralAttributeMapping)this.determineValueMapping(pluralPath);
        if (mappingModelExpressable.getElementDescriptor() instanceof EntityCollectionPart) {
            this.inferrableTypeAccessStack.push(() -> ((EntityCollectionPart)mappingModelExpressable.getElementDescriptor()).getKeyTargetMatchPart());
        } else if (mappingModelExpressable.getElementDescriptor() instanceof EmbeddedCollectionPart) {
            this.inferrableTypeAccessStack.push(() -> mappingModelExpressable.getElementDescriptor());
        } else {
            this.inferrableTypeAccessStack.push(() -> mappingModelExpressable);
        }
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup tableGroup = mappingModelExpressable.createRootTableGroup(pluralPath.getNavigablePath(), null, LockOptions.NONE.getLockMode(), () -> subQuerySpec::applyPredicate, this, this.creationContext);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            CollectionPart elementDescriptor = mappingModelExpressable.getElementDescriptor();
            elementDescriptor.createDomainResult(pluralPath.getNavigablePath(), tableGroup, null, this);
            subQuerySpec.applyPredicate(mappingModelExpressable.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPath.getNavigablePath().getParent()), tableGroup, SqlAstJoinType.INNER, this.getSqlExpressionResolver(), this.creationContext));
        }
        finally {
            this.popProcessingStateStack();
        }
        return new InSubQueryPredicate(lhs, subQuerySpec, predicate.isNegated());
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getRightHandExpression()));
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getLeftHandExpression()));
        try {
            rhs = (Expression)predicate.getRightHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new ComparisonPredicate(lhs, predicate.getSqmOperator(), rhs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        QuerySpec subQuerySpec = new QuerySpec(false, 1);
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        SqlAstProcessingStateImpl subQueryState = new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent);
        this.pushProcessingState(subQueryState);
        try {
            SqmPluralValuedSimplePath<?> sqmPluralPath = predicate.getPluralPath();
            NavigablePath pluralPathNavPath = sqmPluralPath.getNavigablePath();
            NavigablePath parentNavPath = pluralPathNavPath.getParent();
            assert (parentNavPath != null);
            TableGroup parentTableGroup = parentFromClauseAccess.getTableGroup(parentNavPath);
            SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
            CorrelatedTableGroup tableGroup = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, subQuerySpec, subQuerySpec::applyPredicate, this.creationContext.getSessionFactory());
            subQueryState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(parentNavPath, tableGroup);
            Object sqmPathInterpretation = this.visitPluralValuedPath((SqmPluralValuedSimplePath)sqmPluralPath);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)sqmPathInterpretation.getExpressionType();
            pluralAttributeMapping.createTableGroupJoin(pluralPathNavPath, tableGroup, sqmPluralPath.getExplicitAlias(), SqlAstJoinType.INNER, false, LockMode.NONE, this.sqlAliasBaseManager, subQueryState, this.creationContext);
            ForeignKeyDescriptor collectionKeyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            int jdbcTypeCount = collectionKeyDescriptor.getJdbcTypeCount();
            assert (jdbcTypeCount > 0);
            JdbcLiteral<Integer> jdbcLiteral = new JdbcLiteral<Integer>(1, StandardBasicTypes.INTEGER);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, jdbcLiteral));
            ExistsPredicate existsPredicate = new ExistsPredicate(subQuerySpec);
            if (predicate.isNegated()) {
                ExistsPredicate existsPredicate2 = existsPredicate;
                return existsPredicate2;
            }
            NegatedPredicate negatedPredicate = new NegatedPredicate(existsPredicate);
            return negatedPredicate;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getLowerBound()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getLowerBound())));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated());
    }

    @Override
    public LikePredicate visitLikePredicate(SqmLikePredicate predicate) {
        Expression escapeExpression = predicate.getEscapeCharacter() == null ? null : (Expression)predicate.getEscapeCharacter().accept(this);
        return new LikePredicate((Expression)predicate.getMatchExpression().accept(this), (Expression)predicate.getPattern().accept(this), escapeExpression, predicate.isNegated());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
        return new NullnessPredicate((Expression)predicate.getExpression().accept(this), predicate.isNegated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InListPredicate visitInListPredicate(SqmInListPredicate<?> predicate) {
        InListPredicate specialCase;
        SqmParameter sqmParameter;
        SqmExpression<?> sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (sqmParameter = (SqmParameter)sqmExpression).allowMultiValuedBinding() && (specialCase = this.processInListWithSingleParameter(predicate, sqmParameter)) != null) {
            return specialCase;
        }
        InListPredicate inPredicate = new InListPredicate((Expression)predicate.getTestExpression().accept(this), predicate.isNegated());
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getTestExpression()));
        try {
            for (SqmExpression<?> expression : predicate.getListExpressions()) {
                inPredicate.addExpression((Expression)expression.accept(this));
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return inPredicate;
    }

    private InListPredicate processInListWithSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        if (sqmParameter instanceof JpaCriteriaParameter) {
            return this.processInSingleCriteriaParameter(sqmPredicate, (JpaCriteriaParameter)sqmParameter);
        }
        return this.processInSingleHqlParameter(sqmPredicate, sqmParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InListPredicate processInSingleHqlParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter sqmParameter) {
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this));
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression()));
        try {
            boolean first = true;
            for (Object bindValue : domainParamBinding.getBindValues()) {
                SqmParameter sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmParameter;
                    first = false;
                } else {
                    sqmParamToConsume = sqmParameter.copy();
                    this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                }
                inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return inListPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InListPredicate processInSingleCriteriaParameter(SqmInListPredicate<?> sqmPredicate, JpaCriteriaParameter jpaCriteriaParameter) {
        assert (jpaCriteriaParameter.allowsMultiValuedBinding());
        QueryParameterBinding domainParamBinding = this.domainParameterBindings.getBinding(jpaCriteriaParameter);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this));
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression()));
        SqmJpaCriteriaParameterWrapper<?> sqmWrapper = this.jpaCriteriaParamResolutions.get(jpaCriteriaParameter).get();
        try {
            boolean first = true;
            for (Object bindValue : domainParamBinding.getBindValues()) {
                SqmParameter<Object> sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmWrapper;
                    first = false;
                } else {
                    sqmParamToConsume = sqmWrapper.copy();
                    this.domainParameterXref.addExpansion(jpaCriteriaParameter, sqmWrapper, sqmParamToConsume);
                }
                inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return inListPredicate;
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return new InSubQueryPredicate((Expression)this.visitWithInferredType(predicate.getTestExpression(), predicate.getSubQueryExpression()), (QueryPart)this.visitWithInferredType(predicate.getSubQueryExpression(), predicate.getTestExpression()), predicate.isNegated());
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        Object booleanExpression = predicate.getBooleanExpression().accept(this);
        if (booleanExpression instanceof SelfRenderingExpression) {
            return new SelfRenderingPredicate((SelfRenderingExpression)booleanExpression);
        }
        return new ComparisonPredicate((Expression)booleanExpression, ComparisonOperator.EQUAL, new QueryLiteral<Boolean>(true, this.basicType(Boolean.class)));
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate predicate) {
        return new ExistsPredicate((QueryPart)predicate.getExpression().accept(this));
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        ArrayList<Fetch> fetches = CollectionHelper.arrayList(fetchParent.getReferencedMappingType().getNumberOfFetchables());
        ArrayList bagRoles = new ArrayList();
        BiConsumer<Fetchable, Boolean> fetchableBiConsumer = (fetchable, isKeyFetchable) -> {
            Fetch biDirectionalFetch;
            NavigablePath fetchablePath = fetchParent.resolveNavigablePath((Fetchable)fetchable);
            if (!this.isResolvingCircularFetch() && (biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, this)) != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            boolean incrementFetchDepth = fetchable.incrementFetchDepth();
            try {
                Fetch fetch;
                if (incrementFetchDepth) {
                    ++this.fetchDepth;
                }
                if ((fetch = this.buildFetch(fetchablePath, fetchParent, (Fetchable)fetchable, (boolean)isKeyFetchable)) != null) {
                    PluralAttributeMapping pluralAttributeMapping;
                    CollectionClassification collectionClassification;
                    if (fetch.getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof PluralAttributeMapping && (collectionClassification = (pluralAttributeMapping = (PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) == CollectionClassification.BAG) {
                        bagRoles.add(fetchable.getNavigableRole().getNavigableName());
                    }
                    fetches.add(fetch);
                }
            }
            finally {
                if (incrementFetchDepth) {
                    --this.fetchDepth;
                }
            }
        };
        fetchParent.getReferencedMappingContainer().visitKeyFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, true), null);
        fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, false), null);
        if (bagRoles.size() > 1) {
            throw new MultipleBagFetchException(bagRoles);
        }
        return fetches;
    }

    private Fetch buildFetch(NavigablePath fetchablePath, FetchParent fetchParent, Fetchable fetchable, boolean isKeyFetchable) {
        String alias;
        LockMode lockMode = LockMode.READ;
        FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
        boolean joined = false;
        EntityGraphTraversalState.TraversalResult traversalResult = null;
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        SqmAttributeJoin fetchedJoin = fromClauseIndex.findFetchedJoinByPath(fetchablePath);
        if (fetchedJoin != null) {
            assert (fromClauseIndex.getTableGroup(fetchablePath) != null);
            if (fetchedJoin.isFetched()) {
                fetchTiming = FetchTiming.IMMEDIATE;
            }
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            lockMode = this.determineLockMode(alias);
        } else {
            Integer maxDepth;
            TableGroup existingJoinedGroup;
            alias = null;
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    fetchTiming = traversalResult.getFetchStrategy();
                    joined = traversalResult.isJoined();
                } else if (this.getLoadQueryInfluencers().hasEnabledFetchProfiles() && fetchParent instanceof EntityResultGraphNode) {
                    EntityResultGraphNode entityFetchParent = (EntityResultGraphNode)fetchParent;
                    EntityMappingType entityMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
                    String fetchParentEntityName = entityMappingType.getEntityName();
                    String fetchableRole = fetchParentEntityName + "." + fetchable.getFetchableName();
                    for (String enabledFetchProfileName : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
                        FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(enabledFetchProfileName);
                        org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                        fetchTiming = FetchTiming.IMMEDIATE;
                        joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                    }
                }
            }
            if ((existingJoinedGroup = fromClauseIndex.findTableGroup(fetchablePath)) != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null && this.fetchDepth >= maxDepth) {
                joined = false;
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                fromClauseIndex.resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = fromClauseIndex.getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, SqlAstJoinType.LEFT, true, LockMode.NONE, this);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        try {
            Fetch fetch = fetchParent.generateFetchableFetch(fetchable, fetchablePath, fetchTiming, joined, lockMode, alias, this);
            if (fetchable instanceof PluralAttributeMapping && fetch.getTiming() == FetchTiming.IMMEDIATE && joined) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.getCreationContext().getSessionFactory());
                TableGroup tableGroup = fromClauseIndex.getTableGroup(fetchablePath);
                FilterPredicate collectionFieldFilterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), joinable, tableGroup);
                if (collectionFieldFilterPredicate != null) {
                    if (this.collectionFilterPredicates == null) {
                        this.collectionFilterPredicates = new HashMap<String, FilterPredicate>();
                    }
                    this.collectionFilterPredicates.put(tableGroup.getGroupAlias(), collectionFieldFilterPredicate);
                }
                if (pluralAttributeMapping.getCollectionDescriptor().isManyToMany()) {
                    assert (joinable instanceof CollectionPersister);
                    FilterPredicate manyToManyFilterPredicate = FilterHelper.createManyToManyFilterPredicate(this.getLoadQueryInfluencers(), (CollectionPersister)((Object)joinable), tableGroup);
                    if (manyToManyFilterPredicate != null) {
                        assert (tableGroup.getTableReferenceJoins() != null && tableGroup.getTableReferenceJoins().size() == 1);
                        tableGroup.getTableReferenceJoins().get(0).applyPredicate(manyToManyFilterPredicate);
                    }
                }
                if (this.orderByFragmentConsumer != null) {
                    assert (tableGroup.getModelPart() == pluralAttributeMapping);
                    if (pluralAttributeMapping.getOrderByFragment() != null) {
                        this.orderByFragmentConsumer.accept(pluralAttributeMapping.getOrderByFragment(), tableGroup);
                    }
                    if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
                        this.orderByFragmentConsumer.accept(pluralAttributeMapping.getManyToManyOrderByFragment(), tableGroup);
                    }
                }
            }
            Fetch fetch2 = fetch;
            return fetch2;
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
        finally {
            if (this.entityGraphTraversalState != null && traversalResult != null) {
                this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
            }
        }
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    protected static class SqmAliasedNodePositionTracker
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private final List<SqlSelection>[] sqlSelectionsForSqmSelection;
        private int index = -1;

        public SqmAliasedNodePositionTracker(SqlExpressionResolver delegate, int sqmSelectionCount) {
            this.delegate = delegate;
            this.sqlSelectionsForSqmSelection = new List[sqmSelectionCount];
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqlSelectionsForSqmSelection[position];
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            SqlSelection selection = this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
            List<SqlSelection> sqlSelectionList = this.sqlSelectionsForSqmSelection[this.index];
            if (sqlSelectionList == null) {
                this.sqlSelectionsForSqmSelection[this.index] = sqlSelectionList = new ArrayList<SqlSelection>();
            }
            sqlSelectionList.add(selection);
            return selection;
        }
    }

    protected static class DelegatingSqmAliasedNodeCollector
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private SqmAliasedNodeCollector sqmAliasedNodeCollector;

        public DelegatingSqmAliasedNodeCollector(SqlExpressionResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqmAliasedNodeCollector.getSelections(position);
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
        }

        public SqmAliasedNodeCollector getSqmAliasedNodeCollector() {
            return this.sqmAliasedNodeCollector;
        }

        public void setSqmAliasedNodeCollector(SqmAliasedNodeCollector sqmAliasedNodeCollector) {
            this.sqmAliasedNodeCollector = sqmAliasedNodeCollector;
        }
    }

    @Internal
    public static interface SqmAliasedNodeCollector {
        public void next();

        public List<SqlSelection> getSelections(int var1);
    }

    private static class StandardOrderByFragmentConsumer
    implements OrderByFragmentConsumer {
        private Map<OrderByFragment, TableGroup> fragments;

        private StandardOrderByFragmentConsumer() {
        }

        @Override
        public void accept(OrderByFragment orderByFragment, TableGroup tableGroup) {
            if (this.fragments == null) {
                this.fragments = new LinkedHashMap<OrderByFragment, TableGroup>();
            }
            this.fragments.put(orderByFragment, tableGroup);
        }

        @Override
        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> consumer) {
            if (this.fragments == null || this.fragments.isEmpty()) {
                return;
            }
            this.fragments.forEach(consumer);
        }
    }

    private static interface OrderByFragmentConsumer {
        public void accept(OrderByFragment var1, TableGroup var2);

        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> var1);
    }
}

