/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class BasicValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
DomainResultProducer<T> {
    private final ColumnReference columnReference;

    public static <T> BasicValuedPathInterpretation<T> from(SqmBasicValuedSimplePath<T> sqmPath, SqlAstCreationState sqlAstCreationState, SemanticQueryWalker sqmWalker) {
        ColumnReference columnReference;
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(sqmPath.getLhs().getNavigablePath());
        BasicValuedModelPart mapping = (BasicValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        if (mapping == null) {
            throw new SemanticException("`" + sqmPath.getNavigablePath().getFullPath() + "` did not reference a known model part");
        }
        TableReference tableReference = tableGroup.resolveTableReference(sqmPath.getNavigablePath(), mapping.getContainingTableExpression());
        Expression expression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mapping.getSelectionExpression()), sacs -> new ColumnReference(tableReference.getIdentificationVariable(), (SelectableMapping)mapping, sqlAstCreationState.getCreationContext().getSessionFactory()));
        if (expression instanceof ColumnReference) {
            columnReference = (ColumnReference)expression;
        } else if (expression instanceof SqlSelectionExpression) {
            Expression selectedExpression = ((SqlSelectionExpression)expression).getSelection().getExpression();
            assert (selectedExpression instanceof ColumnReference);
            columnReference = (ColumnReference)selectedExpression;
        } else {
            throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
        }
        return new BasicValuedPathInterpretation<T>(columnReference, sqmPath, mapping, tableGroup);
    }

    private BasicValuedPathInterpretation(ColumnReference columnReference, SqmBasicValuedSimplePath<T> sqmPath, BasicValuedModelPart mapping, TableGroup tableGroup) {
        super(sqmPath, mapping, tableGroup);
        assert (columnReference != null);
        this.columnReference = columnReference;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.columnReference.accept(sqlTreeWalker);
    }

    public String toString() {
        return "BasicValuedPathInterpretation(" + this.getNavigablePath().getFullPath() + ')';
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this.columnReference);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this.columnReference);
    }
}

