/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class DiscriminatedAssociationPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer {
    private final SqlTuple sqlTuple;

    public static <T> DiscriminatedAssociationPathInterpretation<T> from(SqmAnyValuedSimplePath<T> sqmPath, SqmToSqlAstConverter converter) {
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        DiscriminatedAssociationModelPart mapping = (DiscriminatedAssociationModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        ArrayList tupleExpressions = new ArrayList();
        mapping.forEachSelectable((selectionIndex, selectableMapping) -> {
            TableReference tableReference = tableGroup.resolveTableReference(sqmPath.getNavigablePath(), selectableMapping.getContainingTableExpression());
            Expression expression = converter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, converter.getCreationContext().getSessionFactory()));
            tupleExpressions.add(expression);
        });
        return new DiscriminatedAssociationPathInterpretation<T>(sqmPath, mapping, tableGroup, new SqlTuple(tupleExpressions, mapping));
    }

    public DiscriminatedAssociationPathInterpretation(SqmPath<T> sqmPath, ModelPart mapping, TableGroup tableGroup, SqlTuple sqlTuple) {
        super(sqmPath, mapping, tableGroup);
        this.sqlTuple = sqlTuple;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlTuple.accept(sqlTreeWalker);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlTuple;
    }
}

