/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.update.Assignable;

public class EmbeddableValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
SqlTupleContainer {
    private final SqlTuple sqlExpression;

    public static <T> EmbeddableValuedPathInterpretation<T> from(SqmEmbeddedValuedSimplePath<T> sqmPath, SqmToSqlAstConverter converter, SemanticQueryWalker sqmWalker) {
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EmbeddableValuedModelPart mapping = (EmbeddableValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return new EmbeddableValuedPathInterpretation<T>(mapping.toSqlExpression(tableGroup, converter.getCurrentClauseStack().getCurrent(), converter, converter), sqmPath, mapping, tableGroup);
    }

    public EmbeddableValuedPathInterpretation(SqlTuple sqlExpression, SqmEmbeddedValuedSimplePath<T> sqmPath, EmbeddableValuedModelPart mapping, TableGroup tableGroup) {
        super(sqmPath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    public SqlTuple getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    public String toString() {
        return "EmbeddableValuedPathInterpretation(" + this.getNavigablePath().getFullPath() + ')';
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        for (Expression expression : this.sqlExpression.getExpressions()) {
            if (!(expression instanceof ColumnReference)) {
                throw new IllegalArgumentException("Expecting ColumnReference, found : " + expression);
            }
            columnReferenceConsumer.accept((ColumnReference)expression);
        }
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        ArrayList<ColumnReference> results = new ArrayList<ColumnReference>();
        this.visitColumnReferences(results::add);
        return results;
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression;
    }
}

