/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.delete;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCriteriaDelete;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;

public class SqmDeleteStatement<T>
extends AbstractSqmDmlStatement<T>
implements SqmDeleteOrUpdateStatement<T>,
JpaCriteriaDelete<T> {
    private final SqmQuerySource querySource;
    private SqmWhereClause whereClause;

    public SqmDeleteStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
        this.querySource = SqmQuerySource.HQL;
    }

    public SqmDeleteStatement(Class<T> targetEntity, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, nodeBuilder), querySource, nodeBuilder);
        this.querySource = SqmQuerySource.CRITERIA;
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    @Override
    public void applyPredicate(SqmPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        this.whereClause.applyPredicate(predicate);
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public Root<T> from(Class<T> entityClass) {
        EntityType entity = this.nodeBuilder().getDomainModel().entity(entityClass);
        SqmRoot root = new SqmRoot(entity, null, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> from(EntityType<T> entity) {
        SqmRoot root = new SqmRoot((EntityDomainType)entity, null, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> getRoot() {
        return this.getTarget();
    }

    public SqmDeleteStatement<T> where(Expression<Boolean> restriction) {
        this.getWhereClause().setPredicate((SqmPredicate)restriction);
        return this;
    }

    public SqmDeleteStatement<T> where(Predicate ... restrictions) {
        this.getWhereClause().setPredicate(null);
        for (Predicate restriction : restrictions) {
            this.getWhereClause().applyPredicate((SqmPredicate)restriction);
        }
        return this;
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.whereClause == null ? null : this.whereClause.getPredicate();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitDeleteStatement(this);
    }
}

