/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;

public class SqmEnumLiteral<E extends Enum<E>>
extends AbstractSqmExpression<E>
implements SqmExpressable<E>,
SemanticPathPart {
    private final E enumValue;
    private final EnumJavaTypeDescriptor<E> referencedEnumTypeDescriptor;
    private final String enumValueName;

    public SqmEnumLiteral(E enumValue, EnumJavaTypeDescriptor<E> referencedEnumTypeDescriptor, String enumValueName, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.enumValue = enumValue;
        this.referencedEnumTypeDescriptor = referencedEnumTypeDescriptor;
        this.enumValueName = enumValueName;
        this.setExpressableType(this);
    }

    public Enum getEnumValue() {
        return this.enumValue;
    }

    public String getEnumValueName() {
        return this.enumValueName;
    }

    @Override
    public EnumJavaTypeDescriptor<E> getExpressableJavaTypeDescriptor() {
        return this.referencedEnumTypeDescriptor;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", ((Class)this.referencedEnumTypeDescriptor.getJavaType()).getTypeName(), this.enumValueName));
    }

    @Override
    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", ((Class)this.referencedEnumTypeDescriptor.getJavaType()).getTypeName(), this.enumValueName));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.nodeBuilder().literal((Object)((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).longValue());
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.nodeBuilder().literal(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue));
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.nodeBuilder().literal(Float.valueOf(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).floatValue()));
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.nodeBuilder().literal((Object)((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).doubleValue());
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigDecimal");
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigInteger");
    }

    @Override
    public SqmExpression<String> asString() {
        return this.nodeBuilder().literal(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toName(this.enumValue));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEnumLiteral(this);
    }
}

