/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

public class SqmOrderByClause {
    private boolean hasPositionalSortItem;
    private List<SqmSortSpecification> sortSpecifications;

    public boolean hasPositionalSortItem() {
        return this.hasPositionalSortItem;
    }

    public SqmOrderByClause addSortSpecification(SqmSortSpecification sortSpecification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SqmSortSpecification>();
        }
        this.sortSpecifications.add(sortSpecification);
        if (sortSpecification.getExpression() instanceof SqmAliasedNodeRef) {
            this.hasPositionalSortItem = true;
        }
        return this;
    }

    public SqmOrderByClause addSortSpecification(SqmExpression<?> expression) {
        this.addSortSpecification(new SqmSortSpecification(expression));
        return this;
    }

    public List<SqmSortSpecification> getSortSpecifications() {
        if (this.sortSpecifications == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sortSpecifications);
    }

    public void setSortSpecifications(List<SqmSortSpecification> sortSpecifications) {
        this.sortSpecifications = new ArrayList<SqmSortSpecification>();
        this.sortSpecifications.addAll(sortSpecifications);
        for (int i = 0; i < sortSpecifications.size(); ++i) {
            SqmSortSpecification sortSpecification = sortSpecifications.get(i);
            if (!(sortSpecification.getExpression() instanceof SqmAliasedNodeRef)) continue;
            this.hasPositionalSortItem = true;
        }
    }
}

