/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Collections;
import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.SetOperator;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaQueryGroup;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;

public class SqmQueryGroup<T>
extends SqmQueryPart<T>
implements JpaQueryGroup<T> {
    private final List<SqmQueryPart<T>> queryParts;
    private SetOperator setOperator;

    public SqmQueryGroup(SqmQueryPart<T> queryPart) {
        this(queryPart.nodeBuilder(), null, CollectionHelper.listOf(queryPart));
    }

    public SqmQueryGroup(NodeBuilder nodeBuilder, SetOperator setOperator, List<SqmQueryPart<T>> queryParts) {
        super(nodeBuilder);
        this.setOperator = setOperator;
        this.queryParts = queryParts;
    }

    public List<SqmQueryPart<T>> queryParts() {
        return this.queryParts;
    }

    @Override
    public SqmQuerySpec<T> getFirstQuerySpec() {
        return this.queryParts.get(0).getFirstQuerySpec();
    }

    @Override
    public SqmQuerySpec<T> getLastQuerySpec() {
        return this.queryParts.get(this.queryParts.size() - 1).getLastQuerySpec();
    }

    @Override
    public boolean isSimpleQueryPart() {
        return this.setOperator == null && this.queryParts.size() == 1 && this.queryParts.get(0).isSimpleQueryPart();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQueryGroup(this);
    }

    @Override
    public List<SqmQueryPart<T>> getQueryParts() {
        return Collections.unmodifiableList(this.queryParts);
    }

    @Override
    public SetOperator getSetOperator() {
        return this.setOperator;
    }

    @Override
    public void setSetOperator(SetOperator setOperator) {
        if (setOperator == null) {
            throw new IllegalArgumentException();
        }
        this.setOperator = setOperator;
    }

    @Override
    public SqmQueryGroup<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        return (SqmQueryGroup)super.setSortSpecifications((List)sortSpecifications);
    }

    @Override
    public SqmQueryGroup<T> setOffset(JpaExpression<?> offset) {
        return (SqmQueryGroup)super.setOffset((JpaExpression)offset);
    }

    @Override
    public SqmQueryGroup<T> setFetch(JpaExpression<?> fetch) {
        return (SqmQueryGroup)super.setFetch((JpaExpression)fetch);
    }

    @Override
    public SqmQueryGroup<T> setFetch(JpaExpression<?> fetch, FetchClauseType fetchClauseType) {
        return (SqmQueryGroup)super.setFetch(fetch, fetchClauseType);
    }
}

