/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.update;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCriteriaUpdate;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;

public class SqmUpdateStatement<T>
extends AbstractSqmDmlStatement<T>
implements SqmDeleteOrUpdateStatement<T>,
JpaCriteriaUpdate<T> {
    private boolean versioned;
    private SqmSetClause setClause;
    private SqmWhereClause whereClause;

    public SqmUpdateStatement(SqmRoot<T> target, NodeBuilder nodeBuilder) {
        this(target, SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmUpdateStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
    }

    public SqmUpdateStatement(Class<T> targetEntity, SqmCriteriaNodeBuilder nodeBuilder) {
        this(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, (NodeBuilder)nodeBuilder), SqmQuerySource.CRITERIA, (NodeBuilder)nodeBuilder);
    }

    public SqmSetClause getSetClause() {
        return this.setClause;
    }

    public void setSetClause(SqmSetClause setClause) {
        this.setClause = setClause;
    }

    @Override
    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    @Override
    public void applyPredicate(SqmPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        this.whereClause.applyPredicate(predicate);
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public Root<T> from(Class<T> entityClass) {
        EntityType entity = this.nodeBuilder().getDomainModel().entity(entityClass);
        SqmRoot root = new SqmRoot(entity, null, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> from(EntityType<T> entity) {
        SqmRoot root = new SqmRoot((EntityDomainType)entity, null, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> getRoot() {
        return this.getTarget();
    }

    public <Y, X extends Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        throw new NotYetImplementedFor6Exception();
    }

    public <Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        throw new NotYetImplementedFor6Exception();
    }

    public <Y, X extends Y> SqmUpdateStatement<T> set(Path<Y> attribute, X value) {
        throw new NotYetImplementedFor6Exception();
    }

    public <Y> SqmUpdateStatement<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        throw new NotYetImplementedFor6Exception();
    }

    public SqmUpdateStatement<T> set(String attributeName, Object value) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isVersioned() {
        return this.versioned;
    }

    @Override
    public SqmUpdateStatement<T> versioned() {
        this.versioned = true;
        return this;
    }

    @Override
    public SqmUpdateStatement<T> versioned(boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    public SqmUpdateStatement<T> where(Expression<Boolean> restriction) {
        this.getWhereClause().setPredicate((SqmPredicate)restriction);
        return this;
    }

    public SqmUpdateStatement<T> where(Predicate ... restrictions) {
        this.getWhereClause().setPredicate(null);
        for (Predicate restriction : restrictions) {
            this.getWhereClause().applyPredicate((SqmPredicate)restriction);
        }
        return this;
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.whereClause == null ? null : this.whereClause.getPredicate();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitUpdateStatement(this);
    }

    public void applyAssignment(SqmPath targetPath, SqmExpression value) {
        if (this.setClause == null) {
            this.setClause = new SqmSetClause();
        }
        this.setClause.addAssignment(new SqmAssignment(targetPath, value));
    }
}

