/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class CteTable {
    private final SessionFactoryImplementor sessionFactory;
    private final String cteName;
    private final List<CteColumn> cteColumns;

    public CteTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> columns.add(new CteColumn("cte_" + selection.getSelectionExpression(), selection.getJdbcMapping())));
        this.cteName = cteName;
        this.cteColumns = columns;
        this.sessionFactory = entityDescriptor.getEntityPersister().getFactory();
    }

    public CteTable(String cteName, List<CteColumn> cteColumns, SessionFactoryImplementor sessionFactory) {
        this.cteName = cteName;
        this.cteColumns = cteColumns;
        this.sessionFactory = sessionFactory;
    }

    public String getTableExpression() {
        return this.cteName;
    }

    public List<CteColumn> getCteColumns() {
        return this.cteColumns;
    }

    public QuerySpec createCteDefinition(List<?> matchingIds, Bindable bindable, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference tableValueConstructorReference = this.createCteDefinitionTableValueCtor(matchingIds, bindable, jdbcParameterBindings, executionContext);
        StandardTableGroup tableValueCtorGroup = new StandardTableGroup(new NavigablePath("cte"), null, LockMode.NONE, tableValueConstructorReference, null, this.sessionFactory);
        querySpec.getFromClause().addRoot(tableValueCtorGroup);
        this.applySelections(querySpec, tableValueConstructorReference);
        return querySpec;
    }

    private TableReference createCteDefinitionTableValueCtor(List<?> matchingValues, Bindable bindable, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        int numberOfColumns = this.getCteColumns().size();
        StringBuilder tableValueCtorExpressionBuffer = new StringBuilder("values(");
        List<JdbcParameter> jdbcParameters = Arrays.asList(new JdbcParameterImpl[numberOfColumns]);
        String rowSeparator = "";
        for (Object matchingId : matchingValues) {
            tableValueCtorExpressionBuffer.append(rowSeparator);
            int separator = 40;
            for (int i = 0; i < numberOfColumns; ++i) {
                tableValueCtorExpressionBuffer.append((char)separator);
                tableValueCtorExpressionBuffer.append('?');
                separator = 44;
                jdbcParameters.set(i, new JdbcParameterImpl(this.cteColumns.get(i).getJdbcMapping()));
            }
            tableValueCtorExpressionBuffer.append(')');
            jdbcParameterBindings.registerParametersForEachJdbcValue(matchingId, Clause.IRRELEVANT, bindable, jdbcParameters, executionContext.getSession());
            rowSeparator = ", ";
        }
        tableValueCtorExpressionBuffer.append(')');
        return new TableReference(tableValueCtorExpressionBuffer.toString(), this.cteName, false, this.sessionFactory);
    }

    public QuerySpec createCteSubQuery(ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference cteTableReference = new TableReference(this.getTableExpression(), null, false, this.sessionFactory);
        CteTableGroup cteTableGroup = new CteTableGroup(cteTableReference);
        querySpec.getFromClause().addRoot(cteTableGroup);
        this.applySelections(querySpec, cteTableReference);
        return querySpec;
    }

    private void applySelections(QuerySpec querySpec, TableReference tableReference) {
        for (int i = 0; i < this.cteColumns.size(); ++i) {
            CteColumn cteColumn = this.cteColumns.get(i);
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(tableReference, cteColumn.getColumnExpression(), false, null, null, cteColumn.getJdbcMapping(), this.sessionFactory)));
        }
    }
}

