/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class LazyTableGroup
extends AbstractColumnReferenceQualifier
implements TableGroup {
    private final NavigablePath navigablePath;
    private final TableGroupProducer producer;
    private final LockMode lockMode;
    private final SqlAliasBase sqlAliasBase;
    private final SessionFactoryImplementor sessionFactory;
    private final Supplier<TableGroup> tableGroupSupplier;
    private final TableGroup parentTableGroup;
    private final Predicate<NavigablePath> navigablePathChecker;
    private Consumer<TableGroup> tableGroupConsumer;
    private TableGroup tableGroup;

    public LazyTableGroup(NavigablePath navigablePath, Supplier<TableGroup> tableGroupSupplier, Predicate<NavigablePath> navigablePathChecker, TableGroupProducer tableGroupProducer, LockMode lockMode, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory, TableGroup parentTableGroup) {
        this.navigablePath = navigablePath;
        this.producer = tableGroupProducer;
        this.lockMode = lockMode;
        this.sqlAliasBase = sqlAliasBase;
        this.tableGroupSupplier = tableGroupSupplier;
        this.navigablePathChecker = navigablePathChecker;
        this.parentTableGroup = parentTableGroup;
        this.sessionFactory = sessionFactory;
    }

    public TableGroup getUnderlyingTableGroup() {
        return this.tableGroup;
    }

    public TableGroup getTableGroup() {
        if (this.tableGroup != null) {
            return this.tableGroup;
        }
        this.tableGroup = this.tableGroupSupplier.get();
        if (this.tableGroupConsumer != null) {
            this.tableGroupConsumer.accept(this.tableGroup);
        }
        return this.tableGroup;
    }

    public void setTableGroupInitializerCallback(Consumer<TableGroup> tableGroupConsumer) {
        this.tableGroupConsumer = tableGroupConsumer;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        if (this.tableGroup != null) {
            this.tableGroup.applyAffectedTableNames(nameCollector);
        }
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.getTableGroup().getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getTableReferenceJoins();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroup == null ? Collections.emptyList() : this.tableGroup.getTableGroupJoins();
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroup != null && this.tableGroup.hasTableGroupJoins();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        this.getTableGroup().addTableGroupJoin(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroup != null) {
            this.tableGroup.visitTableGroupJoins(consumer);
        }
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.sqlAliasBase.getAliasStem();
    }

    @Override
    public TableGroupProducer getModelPart() {
        return this.producer;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public boolean isInnerJoinPossible() {
        return false;
    }

    @Override
    public boolean isRealTableGroup() {
        return false;
    }

    @Override
    public TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression) {
        TableReference reference;
        if ((navigablePath == null || this.navigablePathChecker.test(navigablePath)) && (reference = this.parentTableGroup.getTableReference(navigablePath, tableExpression)) != null) {
            return reference;
        }
        return this.getTableGroup().getTableReference(navigablePath, tableExpression);
    }
}

