/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;

public class TableReference
implements SqlAstNode,
ColumnReferenceQualifier {
    private final String tableExpression;
    private final String identificationVariable;
    private final boolean isOptional;

    public TableReference(String tableExpression, String identificationVariable, boolean isOptional, SessionFactoryImplementor sessionFactory) {
        this.tableExpression = tableExpression;
        this.identificationVariable = identificationVariable;
        this.isOptional = isOptional;
    }

    public String getTableExpression() {
        return this.tableExpression;
    }

    public String getIdentificationVariable() {
        return this.identificationVariable;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReference(this);
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
        if (tableExpression.equals(this.getTableExpression())) {
            return this;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression) {
        if (this.tableExpression.equals(tableExpression)) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.getTableExpression() + "(" + this.getIdentificationVariable() + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReference that = (TableReference)o;
        return Objects.equals(this.identificationVariable, that.identificationVariable);
    }

    public int hashCode() {
        return Objects.hash(this.identificationVariable);
    }
}

