/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.LockOptions;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class JdbcSelect
implements JdbcOperation {
    private final String sql;
    private final List<JdbcParameterBinder> parameterBinders;
    private final JdbcValuesMappingProducer jdbcValuesMappingProducer;
    private final Set<String> affectedTableNames;
    private final Set<FilterJdbcParameter> filterJdbcParameters;
    private final int rowsToSkip;
    private final int maxRows;
    private final Map<JdbcParameter, JdbcParameterBinding> appliedParameters;
    private final LockOptions appliedLockOptions;
    private final JdbcParameter offsetParameter;
    private final JdbcParameter limitParameter;

    public JdbcSelect(String sql, List<JdbcParameterBinder> parameterBinders, JdbcValuesMappingProducer jdbcValuesMappingProducer, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters) {
        this(sql, parameterBinders, jdbcValuesMappingProducer, affectedTableNames, filterJdbcParameters, 0, Integer.MAX_VALUE, Collections.emptyMap(), null, null, null);
    }

    public JdbcSelect(String sql, List<JdbcParameterBinder> parameterBinders, JdbcValuesMappingProducer jdbcValuesMappingProducer, Set<String> affectedTableNames, Set<FilterJdbcParameter> filterJdbcParameters, int rowsToSkip, int maxRows, Map<JdbcParameter, JdbcParameterBinding> appliedParameters, LockOptions appliedLockOptions, JdbcParameter offsetParameter, JdbcParameter limitParameter) {
        this.sql = sql;
        this.parameterBinders = parameterBinders;
        this.jdbcValuesMappingProducer = jdbcValuesMappingProducer;
        this.affectedTableNames = affectedTableNames;
        this.filterJdbcParameters = filterJdbcParameters;
        this.rowsToSkip = rowsToSkip;
        this.maxRows = maxRows;
        this.appliedParameters = appliedParameters;
        this.appliedLockOptions = appliedLockOptions;
        this.offsetParameter = offsetParameter;
        this.limitParameter = limitParameter;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    @Override
    public Set<FilterJdbcParameter> getFilterJdbcParameters() {
        return this.filterJdbcParameters;
    }

    public JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
        return this.jdbcValuesMappingProducer;
    }

    public int getRowsToSkip() {
        return this.rowsToSkip;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public boolean usesLimitParameters() {
        return this.offsetParameter != null || this.limitParameter != null;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        return !this.appliedParameters.isEmpty();
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (!this.appliedParameters.isEmpty()) {
            if (jdbcParameterBindings == null) {
                return false;
            }
            for (Map.Entry<JdbcParameter, JdbcParameterBinding> entry : this.appliedParameters.entrySet()) {
                JdbcParameter parameter = entry.getKey();
                if (parameter == this.offsetParameter || parameter == this.limitParameter) continue;
                JdbcParameterBinding binding = jdbcParameterBindings.getBinding(entry.getKey());
                JdbcParameterBinding appliedBinding = entry.getValue();
                if (binding != null && appliedBinding.getBindType().getJavaTypeDescriptor().areEqual(binding.getBindValue(), appliedBinding.getBindValue())) continue;
                return false;
            }
        }
        LockOptions lockOptions = queryOptions.getLockOptions();
        if (this.appliedLockOptions == null ? lockOptions != null && !lockOptions.isEmpty() : !this.appliedLockOptions.isCompatible(lockOptions)) {
            return false;
        }
        Limit limit = queryOptions.getLimit();
        if (this.offsetParameter == null && this.limitParameter == null && limit != null && !limit.isEmpty()) {
            return false;
        }
        if (!this.isCompatible(this.offsetParameter, limit == null ? null : limit.getFirstRow(), 0)) {
            return false;
        }
        return this.isCompatible(this.limitParameter, limit == null ? null : limit.getMaxRows(), Integer.MAX_VALUE);
    }

    private boolean isCompatible(JdbcParameter parameter, Integer requestedValue, int defaultValue) {
        JdbcParameterBinding jdbcParameterBinding;
        int value = requestedValue == null ? defaultValue : requestedValue;
        return !(parameter != null ? (jdbcParameterBinding = this.appliedParameters.get(parameter)) != null && value != (Integer)jdbcParameterBinding.getBindValue() : value != defaultValue);
    }
}

