/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractImmediateCollectionInitializer
extends AbstractCollectionInitializer {
    private final LockMode lockMode;
    private LoadingCollectionEntryImpl responsibility;
    private final DomainResultAssembler keyContainerAssembler;
    private final DomainResultAssembler keyCollectionAssembler;
    private Object keyContainerValue;
    private Object keyCollectionValue;

    public AbstractImmediateCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler) {
        super(collectionPath, collectionAttributeMapping, parentAccess);
        this.keyContainerAssembler = keyContainerAssembler;
        this.keyCollectionAssembler = keyCollectionAssembler;
        this.lockMode = lockMode;
    }

    protected abstract String getSimpleConcreteImplName();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        block19: {
            LoadingCollectionEntry existingLoadingEntry;
            if (this.collectionInstance != null || this.collectionKey == null) {
                return;
            }
            if (CollectionLoadingLogger.TRACE_ENABLED) {
                CollectionLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveInstance for collection : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
            if ((existingLoadingEntry = (persistenceContext = (session = rowProcessingState.getSession()).getPersistenceContext()).getLoadContexts().findLoadingCollectionEntry(this.collectionKey)) != null) {
                this.collectionInstance = existingLoadingEntry.getCollectionInstance();
                if (CollectionLoadingLogger.DEBUG_ENABLED) {
                    CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing loading collection entry [%s]; using loading collection instance - %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                }
                if (existingLoadingEntry.getInitializer() == this) {
                    this.responsibility = (LoadingCollectionEntryImpl)existingLoadingEntry;
                    break block19;
                } else {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.INSTANCE.debugf("(%s) Collection [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)existingLoadingEntry.getInitializer());
                    }
                    return;
                }
            }
            PersistentCollection existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                if (this.collectionInstance.wasInitialized()) {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                    }
                    return;
                }
                this.takeResponsibility(rowProcessingState, this.collectionKey);
            } else {
                PersistentCollection existingUnowned = persistenceContext.useUnownedCollection(this.collectionKey);
                if (existingUnowned != null) {
                    this.collectionInstance = existingUnowned;
                    if (this.collectionInstance.wasInitialized()) {
                        if (CollectionLoadingLogger.DEBUG_ENABLED) {
                            CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing unowned collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                        }
                        return;
                    }
                    this.takeResponsibility(rowProcessingState, this.collectionKey);
                }
            }
        }
        if (this.collectionInstance == null && this.collectionKey != null) {
            CollectionPersister collectionDescriptor = this.getCollectionAttributeMapping().getCollectionDescriptor();
            CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
            this.collectionInstance = collectionSemantics.instantiateWrapper(this.collectionKey.getKey(), this.getInitializingCollectionDescriptor(), session);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Created new collection wrapper [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, this.collectionKey.getKey());
            this.takeResponsibility(rowProcessingState, this.collectionKey);
        }
        if (this.responsibility != null) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Responsible for loading collection [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            if (this.getParentAccess() != null) {
                this.getParentAccess().registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            }
        }
    }

    private String toLoggableString(PersistentCollection collectionInstance) {
        return collectionInstance == null ? "<null>" : collectionInstance.getClass().getName() + "@" + System.identityHashCode(collectionInstance);
    }

    protected void takeResponsibility(RowProcessingState rowProcessingState, CollectionKey collectionKey) {
        this.responsibility = new LoadingCollectionEntryImpl(this.getCollectionAttributeMapping().getCollectionDescriptor(), this, collectionKey.getKey(), this.collectionInstance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(collectionKey, this.responsibility);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        this.resolveKeyCollectionValue(rowProcessingState);
        CollectionKey loadingKey = rowProcessingState.getCollectionKey();
        if (loadingKey != null && loadingKey.getRole().equals(this.getCollectionAttributeMapping().getNavigableRole().getNavigableName())) {
            this.collectionKey = loadingKey;
            return;
        }
        Object keyContainerValue = this.getKeyContainerValue();
        if (keyContainerValue != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), keyContainerValue);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Current row collection key : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        } else if (this.keyCollectionValue != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), this.keyCollectionValue);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Current row collection key : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        } else {
            Object parentKey = this.parentAccess.getParentKey();
            if (parentKey == null) {
                return;
            }
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), parentKey);
        }
    }

    private void resolveKeyCollectionValue(RowProcessingState rowProcessingState) {
        JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
        this.keyContainerValue = this.keyContainerAssembler.assemble(rowProcessingState, processingOptions);
        this.keyCollectionValue = this.keyCollectionAssembler == null || this.keyContainerAssembler == this.keyCollectionAssembler ? this.keyContainerValue : this.keyCollectionAssembler.assemble(rowProcessingState, processingOptions);
    }

    protected Object getKeyContainerValue() {
        return this.keyContainerValue;
    }

    protected Object getKeyCollectionValue() {
        return this.keyCollectionValue;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.responsibility == null) {
            return;
        }
        CollectionKey collectionKey = this.resolveCollectionKey(rowProcessingState);
        Object collectionValueKey = this.getKeyCollectionValue();
        if (collectionValueKey != null) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Reading element from row for collection [%s] -> %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            this.responsibility.load(loadingState -> this.readCollectionRow(collectionKey, (List)loadingState, rowProcessingState));
        }
    }

    protected abstract void readCollectionRow(CollectionKey var1, List var2, RowProcessingState var3);

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.keyContainerValue = null;
        this.keyCollectionValue = null;
        this.collectionInstance = null;
        this.responsibility = null;
    }
}

