/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogger;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.TypeHelper;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final List<Initializer> identifierInitializers = new ArrayList<Initializer>();
    private final DomainResultAssembler identifierAssembler;
    private final DomainResultAssembler discriminatorAssembler;
    private final DomainResultAssembler versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final Map<AttributeMapping, DomainResultAssembler> assemblerMap;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object entityInstance;
    private boolean missing;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, DomainResult<?> identifierResult, DomainResult<?> discriminatorResult, DomainResult<?> versionResult, DomainResult<Object> rowIdResult, final AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        this.identifierAssembler = identifierResult != null ? identifierResult.createResultAssembler(new AssemblerCreationState(){

            @Override
            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                for (int i = 0; i < AbstractEntityInitializer.this.identifierInitializers.size(); ++i) {
                    Initializer existing = (Initializer)AbstractEntityInitializer.this.identifierInitializers.get(i);
                    if (!existing.getNavigablePath().equals(navigablePath) || !fetchedModelPart.getNavigableRole().equals(existing.getInitializedPart().getNavigableRole())) continue;
                    assert (fetchedModelPart == existing.getInitializedPart());
                    return existing;
                }
                Initializer initializer = creationState.resolveInitializer(navigablePath, fetchedModelPart, producer);
                AbstractEntityInitializer.this.identifierInitializers.add(initializer);
                return initializer;
            }

            @Override
            public SqlAstCreationContext getSqlAstCreationContext() {
                return creationState.getSqlAstCreationContext();
            }
        }) : null;
        this.discriminatorAssembler = discriminatorResult != null ? discriminatorResult.createResultAssembler(creationState) : null;
        this.versionAssembler = versionResult != null ? versionResult.createResultAssembler(creationState) : null;
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(creationState) : null;
        this.assemblerMap = new IdentityHashMap<AttributeMapping, DomainResultAssembler>(this.entityDescriptor.getNumberOfAttributeMappings());
        this.entityDescriptor.visitFetchables(fetchable -> {
            AttributeMapping attributeMapping = (AttributeMapping)fetchable;
            Fetch fetch = resultDescriptor.findFetch((Fetchable)fetchable);
            NullValueAssembler stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaTypeDescriptor()) : fetch.createAssembler(this, creationState);
            this.assemblerMap.put(attributeMapping, stateAssembler);
        }, null);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        if (this.entityKey == null) {
            return null;
        }
        return this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public Object getFetchParentInstance() {
        if (this.entityInstance == null) {
            throw new IllegalStateException("Unexpected state condition - entity instance not yet resolved");
        }
        return this.getEntityInstance();
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath().getFullPath());
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState, session);
        if (this.concreteDescriptor == null) {
            this.missing = true;
            return;
        }
        this.resolveEntityKey(rowProcessingState);
        if (this.entityKey == null) {
            EntityLoadingLogger.LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
            assert (this.missing);
            return;
        }
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), this.entityKey.getIdentifier());
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        Object discriminatorValue = this.discriminatorAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        String concreteEntityName = ((Loadable)this.entityDescriptor.getRootEntityDescriptor()).getSubclassForDiscriminatorValue(discriminatorValue);
        if (concreteEntityName == null) {
            return this.entityDescriptor;
        }
        EntityPersister concreteType = session.getFactory().getMetamodel().findEntityDescriptor(concreteEntityName);
        if (concreteType == null || !concreteType.isTypeOrSuperType(this.entityDescriptor)) {
            throw new WrongClassException(concreteEntityName, null, this.entityDescriptor.getEntityName(), discriminatorValue);
        }
        assert (concreteType.isTypeOrSuperType(this.entityDescriptor));
        return concreteType;
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey != null) {
            return;
        }
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        SharedSessionContractImplementor session = jdbcValuesSourceProcessingState.getSession();
        Object id = this.initializeIdentifier(rowProcessingState, jdbcValuesSourceProcessingState);
        if (id == null) {
            this.missing = true;
            return;
        }
        this.entityKey = new EntityKey(id, this.concreteDescriptor);
        if (jdbcValuesSourceProcessingState.findInitializer(this.entityKey) == null) {
            jdbcValuesSourceProcessingState.registerInitilaizer(this.entityKey, this);
        }
        if (this.concreteDescriptor.isBatchLoadable() && !session.getPersistenceContext().containsEntity(this.entityKey)) {
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
        }
    }

    private Object initializeIdentifier(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState) {
        boolean useEmbeddedIdentifierInstanceAsEntity;
        Object id = jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId();
        boolean bl = useEmbeddedIdentifierInstanceAsEntity = id != null && id.getClass().equals(this.concreteDescriptor.getJavaTypeDescriptor().getJavaType());
        if (useEmbeddedIdentifierInstanceAsEntity) {
            this.entityInstance = id;
            return id;
        }
        if (this.identifierAssembler == null) {
            return id;
        }
        this.initializeIdentifier(rowProcessingState);
        return this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
    }

    protected void initializeIdentifier(RowProcessingState rowProcessingState) {
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#initializeIdentifier process for entity (%s) ", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
        this.identifierInitializers.forEach(initializer -> initializer.resolveKey(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.resolveInstance(rowProcessingState));
        this.identifierInitializers.forEach(initializer -> initializer.initializeInstance(rowProcessingState));
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Fiish Initializer#initializeIdentifier process for entity (%s) ", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        Object proxy;
        if (this.missing) {
            return;
        }
        if (this.entityInstance != null) {
            return;
        }
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        if ((proxy = this.getProxy(persistenceContext = (session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession()).getPersistenceContext())) != null && (proxy instanceof MapProxy || this.concreteDescriptor.isInstance(proxy))) {
            this.entityInstance = proxy;
        } else {
            Object existingEntity = persistenceContext.getEntity(this.entityKey);
            if (existingEntity != null) {
                this.entityInstance = existingEntity;
            } else if (this.entityInstance == null) {
                this.entityInstance = this.resolveInstance(entityIdentifier, rowProcessingState, session, persistenceContext);
            }
        }
        this.notifyParentResolutionListeners(this.entityInstance);
        this.preLoad(rowProcessingState);
    }

    protected Object getProxy(PersistenceContext persistenceContext) {
        return persistenceContext.getProxy(this.entityKey);
    }

    private Object resolveInstance(Object entityIdentifier, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
        LoadingEntityEntry existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey);
        Object instance = null;
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            instance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogger.DEBUG_ENABLED) {
                    EntityLoadingLogger.LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
                }
                return instance;
            }
        }
        if (instance == null && this.isEntityReturn()) {
            Object requestedEntityId = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalId();
            Object optionalEntityInstance = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject();
            if (requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier())) {
                instance = optionalEntityInstance;
            }
        }
        if (instance == null) {
            instance = session.instantiate(this.concreteDescriptor.getEntityName(), this.entityKey.getIdentifier());
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), instance);
            }
        }
        LoadingEntityEntry loadingEntry = new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, instance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, loadingEntry);
        return instance;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.missing) {
            return;
        }
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (this.entityInstance instanceof HibernateProxy) {
            LazyInitializer hibernateLazyInitializer = ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer();
            if (!hibernateLazyInitializer.isUninitialized()) {
                return;
            }
            Object instance = this.resolveInstance(this.entityKey.getIdentifier(), rowProcessingState, session, persistenceContext);
            this.initializeEntity(instance, rowProcessingState, session, persistenceContext);
            hibernateLazyInitializer.setImplementation(instance);
        } else {
            this.initializeEntity(this.entityInstance, rowProcessingState, session, persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEntity(Object toInitialize, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
        Status status;
        EntityEntry entry = persistenceContext.getEntry(toInitialize);
        if (entry != null && entry.getStatus() != Status.LOADING) {
            return;
        }
        Object entity = persistenceContext.getEntity(this.entityKey);
        assert (entity == null || entity == toInitialize);
        Object entityIdentifier = this.entityKey.getIdentifier();
        if (EntityLoadingLogger.TRACE_ENABLED) {
            EntityLoadingLogger.LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (persistenceContext.containsEntity(this.entityKey) && ((status = persistenceContext.getEntry(entity).getStatus()) == Status.DELETED || status == Status.GONE)) {
            return;
        }
        this.entityDescriptor.setIdentifier(toInitialize, entityIdentifier, session);
        this.resolvedEntityState = this.concreteDescriptor.extractConcreteTypeStateValues(this.assemblerMap, rowProcessingState);
        this.concreteDescriptor.setPropertyValues(toInitialize, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, toInitialize);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), version, this.lockMode, true, this.concreteDescriptor, false);
        SessionFactoryImplementor factory = session.getFactory();
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        if (cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            if (EntityLoadingLogger.DEBUG_ENABLED) {
                EntityLoadingLogger.LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            CacheEntry cacheEntry = this.concreteDescriptor.buildCacheEntry(toInitialize, this.resolvedEntityState, version, session);
            Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
            if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
                cacheAccess.update(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
            } else {
                SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
                try {
                    eventListenerManager.cachePutStart();
                    boolean put = cacheAccess.putFromLoad(session, cacheKey, this.rootEntityDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventListenerManager.cachePutEnd();
                }
            }
        }
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(entityIdentifier, this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(this.resolvedEntityState, session), this.entityDescriptor);
        }
        boolean isReallyReadOnly = this.isReadOnly(rowProcessingState, session);
        if (!this.concreteDescriptor.isMutable()) {
            isReallyReadOnly = true;
        } else if (this.entityInstance instanceof HibernateProxy) {
            isReallyReadOnly = ((HibernateProxy)this.entityInstance).getHibernateLazyInitializer().isReadOnly();
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState, attributeMapping -> attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(this.concreteDescriptor).isUpdatable());
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        this.concreteDescriptor.afterInitialize(toInitialize, session);
        if (EntityLoadingLogger.DEBUG_ENABLED) {
            EntityLoadingLogger.LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatistics().loadEntity(this.concreteDescriptor.getEntityName());
        }
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        if (persistenceContext.isDefaultReadOnly()) {
            return true;
        }
        Boolean queryOption = rowProcessingState.getJdbcValuesSourceProcessingState().getQueryOptions().isReadOnly();
        return queryOption == null ? false : queryOption;
    }

    private void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
        if (session instanceof EventSource) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD;
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.entityInstance = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.identifierInitializers.forEach(initializer -> initializer.finishUpRow(rowProcessingState));
        this.clearParentResolutionListeners();
    }
}

