/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntityFetchSelectImpl
extends AbstractNonJoinedEntityFetch {
    private final boolean nullable;
    private final DomainResult result;
    private final boolean selectByUniqueKey;

    public EntityFetchSelectImpl(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, boolean nullable, NavigablePath navigablePath, DomainResult result, boolean selectByUniqueKey, DomainResultCreationState creationState) {
        super(navigablePath, fetchedAttribute, fetchParent);
        this.nullable = nullable;
        this.result = result;
        this.selectByUniqueKey = selectByUniqueKey;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getFetchedMapping(), () -> {
            EntityPersister entityPersister = this.getReferencedMappingContainer().getEntityPersister();
            if (this.selectByUniqueKey) {
                return new EntitySelectFetchByUniqueKeyInitializer(parentAccess, (ToOneAttributeMapping)this.getFetchedMapping(), this.getNavigablePath(), entityPersister, this.result.createResultAssembler(creationState), this.nullable);
            }
            return new EntitySelectFetchInitializer(parentAccess, (ToOneAttributeMapping)this.getFetchedMapping(), this.getNavigablePath(), entityPersister, this.result.createResultAssembler(creationState), this.nullable);
        });
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }
}

