/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;

public class EntityJoinedFetchInitializer
extends AbstractEntityInitializer {
    private static final String CONCRETE_NAME = EntityJoinedFetchInitializer.class.getSimpleName();
    private final ModelPart referencedModelPart;
    private final boolean isEnhancedForLazyLoading;

    protected EntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, ModelPart referencedModelPart, NavigablePath navigablePath, LockMode lockMode, DomainResult<?> identifierResult, DomainResult<?> discriminatorResult, DomainResult<?> versionResult, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierResult, discriminatorResult, versionResult, null, creationState);
        this.referencedModelPart = referencedModelPart;
        this.isEnhancedForLazyLoading = this.getConcreteDescriptor() != null ? this.getConcreteDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() : false;
    }

    @Override
    protected Object getProxy(PersistenceContext persistenceContext) {
        if (this.referencedModelPart instanceof ToOneAttributeMapping) {
            boolean unwrapProxy;
            boolean bl = unwrapProxy = ((ToOneAttributeMapping)this.referencedModelPart).isUnwrapProxy() && this.isEnhancedForLazyLoading;
            if (unwrapProxy) {
                return null;
            }
        }
        return super.getProxy(persistenceContext);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected boolean isEntityReturn() {
        return false;
    }

    public String toString() {
        return "EntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

