/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.internal.StandardRowReader;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ResultsHelper {
    public static <R> RowReader<R> createRowReader(final SessionFactoryImplementor sessionFactory, Callback callback, RowTransformer<R> rowTransformer, JdbcValues jdbcValues) {
        final LinkedHashMap initializerMap = new LinkedHashMap();
        final ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        List<DomainResultAssembler> assemblers = jdbcValues.getValuesMapping().resolveAssemblers(new AssemblerCreationState(){

            @Override
            public Initializer resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer> producer) {
                Initializer existing = (Initializer)initializerMap.get(navigablePath);
                if (existing != null && fetchedModelPart.getNavigableRole().equals(existing.getInitializedPart().getNavigableRole())) {
                    ResultsLogger.LOGGER.tracef("Returning previously-registered initializer : %s", existing);
                    return existing;
                }
                Initializer initializer = producer.get();
                ResultsLogger.LOGGER.tracef("Registering initializer : %s", initializer);
                initializerMap.put(navigablePath, initializer);
                initializers.add(initializer);
                return initializer;
            }

            @Override
            public SqlAstCreationContext getSqlAstCreationContext() {
                return sessionFactory;
            }
        });
        return new StandardRowReader<R>(assemblers, initializers, rowTransformer, callback);
    }

    public static void finalizeCollectionLoading(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection collectionInstance, Object key) {
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(collectionDescriptor, collectionInstance, key);
        } else {
            collectionEntry.postInitialize(collectionInstance);
        }
        if (collectionDescriptor.getCollectionType().hasHolder()) {
            persistenceContext.addCollectionHolder(collectionInstance);
        }
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        batchFetchQueue.removeBatchLoadableCollection(collectionEntry);
        StatisticsImplementor statistics = persistenceContext.getSession().getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.loadCollection(collectionDescriptor.getRole());
        }
    }
}

