/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;

public class RowProcessingStateStandardImpl
implements RowProcessingState {
    private static final Initializer[] NO_INITIALIZERS = new Initializer[0];
    private final JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState;
    private final Initializer[] initializers;
    private final RowReader<?> rowReader;
    private final JdbcValues jdbcValues;
    private final ExecutionContext executionContext;

    public RowProcessingStateStandardImpl(JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState, ExecutionContext executionContext, RowReader<?> rowReader, JdbcValues jdbcValues) {
        this.resultSetProcessingState = resultSetProcessingState;
        this.executionContext = executionContext;
        this.rowReader = rowReader;
        this.jdbcValues = jdbcValues;
        List<Initializer> initializers = rowReader.getInitializers();
        this.initializers = initializers == null || initializers.isEmpty() ? NO_INITIALIZERS : initializers.toArray(new Initializer[initializers.size()]);
    }

    @Override
    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.resultSetProcessingState;
    }

    @Override
    public RowReader<?> getRowReader() {
        return this.rowReader;
    }

    public boolean next() {
        return this.jdbcValues.next(this);
    }

    public boolean previous() {
        return this.jdbcValues.previous(this);
    }

    public boolean scroll(int i) {
        return this.jdbcValues.scroll(i, this);
    }

    public boolean position(int i) {
        return this.jdbcValues.position(i, this);
    }

    public int getPosition() {
        return this.jdbcValues.getPosition();
    }

    public boolean first() {
        return this.jdbcValues.first(this);
    }

    public boolean last() {
        return this.jdbcValues.last(this);
    }

    @Override
    public Object getJdbcValue(int position) {
        return this.jdbcValues.getCurrentRowValuesArray()[position];
    }

    @Override
    public void registerNonExists(EntityFetch fetch) {
    }

    @Override
    public void finishRowProcessing() {
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getSession();
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getQueryParameterBindings();
    }

    @Override
    public Callback getCallback() {
        return afterLoadAction -> {};
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.executionContext.getCollectionKey();
    }

    @Override
    public Initializer resolveInitializer(NavigablePath path) {
        for (Initializer initializer : this.initializers) {
            if (!initializer.getNavigablePath().equals(path)) continue;
            return initializer;
        }
        return null;
    }
}

