/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.TupleElement;

public final class TupleMetadata {
    private final Map<TupleElement<?>, Integer> index;
    private Map<String, Integer> nameIndex;
    private List<TupleElement<?>> list;

    public TupleMetadata(Map<TupleElement<?>, Integer> index) {
        this.index = index;
    }

    public Integer get(TupleElement<?> tupleElement) {
        return this.index.get(tupleElement);
    }

    public Integer get(String name) {
        Map<String, Integer> nameIndex = this.nameIndex;
        if (nameIndex == null) {
            nameIndex = new HashMap<String, Integer>(this.index.size());
            for (Map.Entry<TupleElement<?>, Integer> entry : this.index.entrySet()) {
                nameIndex.put(entry.getKey().getAlias(), entry.getValue());
            }
            this.nameIndex = nameIndex = Collections.unmodifiableMap(nameIndex);
        }
        return nameIndex.get(name);
    }

    public List<TupleElement<?>> getList() {
        List<TupleElement<?>> list = this.list;
        if (list == null) {
            TupleElement[] array = new TupleElement[this.index.size()];
            for (Map.Entry<TupleElement<?>, Integer> entry : this.index.entrySet()) {
                array[entry.getValue().intValue()] = entry.getKey();
            }
            this.list = list = Collections.unmodifiableList(Arrays.asList(array));
        }
        return list;
    }
}

