/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CircularBiDirectionalFetchImpl
implements BiDirectionalFetch,
Association {
    private final FetchTiming timing;
    private final NavigablePath navigablePath;
    private final Fetchable fetchable;
    private final FetchParent fetchParent;
    private final LockMode lockMode;
    private final NavigablePath referencedNavigablePath;

    public CircularBiDirectionalFetchImpl(FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, Fetchable fetchable, LockMode lockMode, NavigablePath referencedNavigablePath) {
        this.timing = timing;
        this.fetchParent = fetchParent;
        this.navigablePath = navigablePath;
        this.fetchable = fetchable;
        this.lockMode = lockMode;
        this.referencedNavigablePath = referencedNavigablePath;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchable;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.fetchable.getJavaTypeDescriptor();
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.fetchable, this.getReferencedPath(), this.fetchable.getJavaTypeDescriptor());
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public String getFetchableName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public String getPartName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.fetchable.getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.fetchable.findContainingEntityMapping();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.fetchable.getPartMappingType();
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.fetchable.getJavaTypeDescriptor();
    }

    @Override
    public FetchStrategy getMappedFetchOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return ((Association)((Object)this.fetchParent)).getForeignKeyDescriptor();
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ((Association)((Object)this.fetchParent)).getSideNature();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.fetchable.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler {
        private final NavigablePath circularPath;
        private final JavaTypeDescriptor javaTypeDescriptor;
        private final Fetchable fetchable;

        public CircularFetchAssembler(Fetchable fetchable, NavigablePath circularPath, JavaTypeDescriptor javaTypeDescriptor) {
            this.fetchable = fetchable;
            this.circularPath = circularPath;
            this.javaTypeDescriptor = javaTypeDescriptor;
        }

        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            EntityInitializer initializer = this.resolveCircularInitializer(rowProcessingState);
            if (initializer == null) {
                Initializer parentInitializer = rowProcessingState.resolveInitializer(this.circularPath);
                if (this.circularPath.getParent() != null) {
                    initializer = (EntityInitializer)rowProcessingState.resolveInitializer(this.circularPath.getParent());
                } else {
                    assert (parentInitializer instanceof CollectionInitializer);
                    CollectionInitializer circ = (CollectionInitializer)parentInitializer;
                    CollectionKey collectionKey = circ.resolveCollectionKey(rowProcessingState);
                    EntityKey entityKey = new EntityKey(collectionKey.getKey(), (EntityPersister)((AttributeMapping)this.fetchable).getMappedType());
                    SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
                    PersistenceContext persistenceContext = session.getPersistenceContext();
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy == null) {
                        return persistenceContext.getEntity(entityKey);
                    }
                    return proxy;
                }
            }
            if (initializer.getInitializedInstance() == null) {
                initializer.resolveKey(rowProcessingState);
                initializer.resolveInstance(rowProcessingState);
            }
            return initializer.getInitializedInstance();
        }

        private EntityInitializer resolveCircularInitializer(RowProcessingState rowProcessingState) {
            Initializer initializer = rowProcessingState.resolveInitializer(this.circularPath);
            if (initializer instanceof EntityInitializer) {
                return (EntityInitializer)initializer;
            }
            if (initializer instanceof CollectionInitializer) {
                return null;
            }
            ModelPart initializedPart = initializer.getInitializedPart();
            if (initializedPart instanceof EntityInitializer) {
                return (EntityInitializer)((Object)initializedPart);
            }
            NavigablePath path = this.circularPath.getParent();
            Initializer parentInitializer = rowProcessingState.resolveInitializer(path);
            while (!(parentInitializer instanceof EntityInitializer) && path.getParent() != null) {
                path = path.getParent();
                parentInitializer = rowProcessingState.resolveInitializer(path);
            }
            if (!(parentInitializer instanceof EntityInitializer)) {
                return null;
            }
            return (EntityInitializer)parentInitializer;
        }

        public JavaTypeDescriptor getAssembledJavaTypeDescriptor() {
            return this.javaTypeDescriptor;
        }
    }
}

