/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;
import org.jboss.logging.Logger;

public class DeferredResultSetAccess
extends AbstractResultSetAccess {
    private static final Logger log = CoreLogging.logger(DeferredResultSetAccess.class);
    private final JdbcSelect jdbcSelect;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final ExecutionContext executionContext;
    private final Function<String, PreparedStatement> statementCreator;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DeferredResultSetAccess(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator) {
        super(executionContext.getSession());
        this.jdbcParameterBindings = jdbcParameterBindings;
        this.executionContext = executionContext;
        this.jdbcSelect = jdbcSelect;
        this.statementCreator = statementCreator;
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.executionContext.getSession().getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        LimitHandler limitHandler;
        Limit limit;
        String finalSql;
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        JdbcServices jdbcServices = this.getPersistenceContext().getFactory().getServiceRegistry().getService(JdbcServices.class);
        QueryOptions queryOptions = this.executionContext.getQueryOptions();
        if (queryOptions == null) {
            finalSql = this.jdbcSelect.getSql();
            limit = null;
            limitHandler = NoopLimitHandler.NO_LIMIT;
        } else {
            Object sql;
            Dialect dialect = this.executionContext.getSession().getJdbcServices().getDialect();
            limit = queryOptions.getLimit();
            if (limit == null || limit.isEmpty() || this.jdbcSelect.usesLimitParameters()) {
                sql = this.jdbcSelect.getSql();
                limitHandler = NoopLimitHandler.NO_LIMIT;
            } else {
                limitHandler = dialect.getLimitHandler();
                sql = limitHandler.processSql(this.jdbcSelect.getSql(), limit);
            }
            finalSql = dialect.addSqlHintOrComment(this.applyLocks((String)sql, queryOptions.getLockOptions()), queryOptions, this.executionContext.getSession().getFactory().getSessionFactoryOptions().isCommentsEnabled());
        }
        try {
            log.tracef("Executing query to retrieve ResultSet : %s", (Object)finalSql);
            this.preparedStatement = this.statementCreator.apply(finalSql);
            if (queryOptions != null) {
                if (queryOptions.getFetchSize() != null) {
                    this.preparedStatement.setFetchSize(queryOptions.getFetchSize());
                }
                if (queryOptions.getTimeout() != null) {
                    this.preparedStatement.setQueryTimeout(queryOptions.getTimeout());
                }
            }
            int paramBindingPosition = 1;
            paramBindingPosition += limitHandler.bindLimitParametersAtStartOfQuery(limit, this.preparedStatement, paramBindingPosition);
            for (JdbcParameterBinder parameterBinder : this.jdbcSelect.getParameterBinders()) {
                parameterBinder.bindParameterValue(this.preparedStatement, paramBindingPosition++, this.jdbcParameterBindings, this.executionContext);
            }
            paramBindingPosition += limitHandler.bindLimitParametersAtEndOfQuery(limit, this.preparedStatement, paramBindingPosition);
            if (!this.jdbcSelect.usesLimitParameters() && limit != null && limit.getMaxRows() != null) {
                limitHandler.setMaxRows(limit, this.preparedStatement);
            } else {
                int maxRows = this.jdbcSelect.getMaxRows();
                if (maxRows != Integer.MAX_VALUE) {
                    this.preparedStatement.setMaxRows(maxRows);
                }
            }
            this.executionContext.getSession().getEventListenerManager().jdbcExecuteStatementStart();
            try {
                this.resultSet = this.preparedStatement.executeQuery();
            }
            finally {
                this.executionContext.getSession().getEventListenerManager().jdbcExecuteStatementEnd();
            }
            int rowsToSkip = !this.jdbcSelect.usesLimitParameters() && limit != null && limit.getFirstRow() != null && !limitHandler.supportsLimitOffset() ? limit.getFirstRow().intValue() : this.jdbcSelect.getRowsToSkip();
            if (rowsToSkip != 0) {
                this.resultSet.absolute(rowsToSkip);
            }
            logicalConnection.getResourceRegistry().register(this.resultSet, this.preparedStatement);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "JDBC exception executing SQL [" + finalSql + "]");
        }
        finally {
            logicalConnection.afterStatement();
        }
    }

    private String applyLocks(String sql, LockOptions lockOptions) {
        if (lockOptions != null && !lockOptions.isEmpty()) {
            LockOptions originalLockOptions = lockOptions.makeCopy();
            this.executionContext.getCallback().registerAfterLoadAction((session, entity, persister) -> ((Session)((Object)session)).buildLockRequest(originalLockOptions).lock(persister.getEntityName(), entity));
        }
        return sql;
    }

    @Override
    public void release() {
        if (this.resultSet != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.resultSet, this.preparedStatement);
            this.resultSet = null;
        }
        if (this.preparedStatement != null) {
            this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.preparedStatement);
            this.preparedStatement = null;
        }
    }
}

