/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class BooleanType
extends AbstractSingleColumnStandardBasicType<Boolean>
implements PrimitiveType<Boolean>,
DiscriminatorType<Boolean>,
AdjustableBasicType<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    public BooleanType() {
        this((JdbcTypeDescriptor)org.hibernate.type.descriptor.jdbc.BooleanTypeDescriptor.INSTANCE, BooleanTypeDescriptor.INSTANCE);
    }

    protected BooleanType(JdbcTypeDescriptor jdbcTypeDescriptor, BooleanTypeDescriptor javaTypeDescriptor) {
        super(jdbcTypeDescriptor, javaTypeDescriptor);
    }

    @Incubating
    public BooleanType(JdbcTypeDescriptor jdbcTypeDescriptor, JavaTypeDescriptor<Boolean> javaTypeDescriptor) {
        super(jdbcTypeDescriptor, javaTypeDescriptor);
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Boolean.TYPE.getName(), Boolean.class.getName()};
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean stringToObject(String string) {
        return (Boolean)this.fromString(string);
    }

    @Override
    public String objectToSQLString(Boolean value, Dialect dialect) {
        return dialect.toBooleanValueString(value);
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        int preferredSqlTypeCodeForBoolean = indicators.getPreferredSqlTypeCodeForBoolean();
        JdbcTypeDescriptor jdbcTypeDescriptor = preferredSqlTypeCodeForBoolean != -7 && preferredSqlTypeCodeForBoolean != this.getJdbcTypeDescriptor().getJdbcTypeCode() ? indicators.getTypeConfiguration().getJdbcTypeDescriptorRegistry().getDescriptor(preferredSqlTypeCodeForBoolean) : indicators.getTypeConfiguration().getJdbcTypeDescriptorRegistry().getDescriptor(16);
        if (jdbcTypeDescriptor != this.getJdbcTypeDescriptor()) {
            return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), jdbcTypeDescriptor);
        }
        return this;
    }
}

