/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Calendar;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.descriptor.java.CalendarTimeTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TimeTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarTimeType
extends AbstractSingleColumnStandardBasicType<Calendar>
implements AllowableTemporalParameterType<Calendar> {
    public static final CalendarTimeType INSTANCE = new CalendarTimeType();

    public CalendarTimeType() {
        super(TimeTypeDescriptor.INSTANCE, CalendarTimeTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "calendar_time";
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIME: {
                return this;
            }
            case DATE: {
                return CalendarDateType.INSTANCE;
            }
            case TIMESTAMP: {
                return CalendarType.INSTANCE;
            }
        }
        throw new QueryException("Calendar-time type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

