/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarTimeType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CalendarType
extends AbstractSingleColumnStandardBasicType<Calendar>
implements VersionType<Calendar>,
AllowableTemporalParameterType<Calendar> {
    public static final CalendarType INSTANCE = new CalendarType();

    public CalendarType() {
        super(TimestampTypeDescriptor.INSTANCE, CalendarTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "calendar";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Calendar.class.getName(), GregorianCalendar.class.getName()};
    }

    @Override
    public Calendar next(Calendar current, SharedSessionContractImplementor session) {
        return this.seed(session);
    }

    @Override
    public Calendar seed(SharedSessionContractImplementor session) {
        return Calendar.getInstance();
    }

    @Override
    public Comparator<Calendar> getComparator() {
        return this.getJavaTypeDescriptor().getComparator();
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
            case DATE: {
                return CalendarDateType.INSTANCE;
            }
            case TIME: {
                return CalendarTimeType.INSTANCE;
            }
        }
        throw new QueryException("Calendar type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

