/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.Clob;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ClobType
extends AbstractSingleColumnStandardBasicType<Clob>
implements AdjustableBasicType<Clob> {
    public static final ClobType INSTANCE = new ClobType();

    public ClobType() {
        super(ClobTypeDescriptor.DEFAULT, org.hibernate.type.descriptor.java.ClobTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "clob";
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    protected Clob getReplacement(Clob original, Clob target, SharedSessionContractImplementor session) {
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getLobMergeStrategy().mergeClob(original, target, session);
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        if (!indicators.isNationalized()) {
            return this;
        }
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
        return typeConfiguration.getBasicTypeRegistry().resolve(domainJtd, jdbcTypeRegistry.getDescriptor(2011));
    }
}

