/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MaterializedClobType
extends AbstractSingleColumnStandardBasicType<String>
implements AdjustableBasicType<String> {
    public static final MaterializedClobType INSTANCE = new MaterializedClobType();

    public MaterializedClobType() {
        super(ClobTypeDescriptor.DEFAULT, StringTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "materialized_clob";
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        if (indicators.isNationalized()) {
            TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
            JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
            JdbcTypeDescriptor nclobType = jdbcTypeRegistry.getDescriptor(2011);
            return typeConfiguration.getBasicTypeRegistry().resolve(domainJtd, nclobType);
        }
        return this;
    }
}

