/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.CastType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class NumericBooleanType
extends AbstractSingleColumnStandardBasicType<Boolean>
implements PrimitiveType<Boolean>,
DiscriminatorType<Boolean>,
ConvertedBasicType<Boolean> {
    public static final NumericBooleanType INSTANCE = new NumericBooleanType();
    public static final NumericConverter CONVERTER = new NumericConverter();

    public NumericBooleanType() {
        super(org.hibernate.type.descriptor.jdbc.IntegerTypeDescriptor.INSTANCE, BooleanTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "numeric_boolean";
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean stringToObject(String string) {
        return (Boolean)this.fromString(string);
    }

    @Override
    public String objectToSQLString(Boolean value, Dialect dialect) {
        return value != false ? "1" : "0";
    }

    @Override
    public CastType getCastType() {
        return CastType.INTEGER_BOOLEAN;
    }

    @Override
    public BasicValueConverter<Boolean, ?> getValueConverter() {
        return CONVERTER;
    }

    public static class NumericConverter
    implements BasicValueConverter<Boolean, Integer> {
        public static final NumericConverter INSTANCE = new NumericConverter();

        @Override
        public Boolean toDomainValue(Integer relationalForm) {
            return NumericConverter.toDomain(relationalForm);
        }

        public static Boolean toDomain(Integer relationalForm) {
            if (relationalForm == null) {
                return null;
            }
            if (1 == relationalForm) {
                return true;
            }
            if (0 == relationalForm) {
                return false;
            }
            return null;
        }

        @Override
        public Integer toRelationalValue(Boolean domainForm) {
            return NumericConverter.toRelational(domainForm);
        }

        public static Integer toRelational(Boolean domainForm) {
            if (domainForm == null) {
                return null;
            }
            return domainForm != false ? 1 : 0;
        }

        @Override
        public JavaTypeDescriptor<Boolean> getDomainJavaDescriptor() {
            return BooleanTypeDescriptor.INSTANCE;
        }

        @Override
        public JavaTypeDescriptor<Integer> getRelationalJavaDescriptor() {
            return IntegerTypeDescriptor.INSTANCE;
        }
    }
}

