/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarTimeType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterNCharType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.DurationType;
import org.hibernate.type.FloatType;
import org.hibernate.type.ImageType;
import org.hibernate.type.InstantType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.LocalDateTimeType;
import org.hibernate.type.LocalDateType;
import org.hibernate.type.LocalTimeType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.MaterializedNClobType;
import org.hibernate.type.NClobType;
import org.hibernate.type.NTextType;
import org.hibernate.type.NumericBooleanType;
import org.hibernate.type.OffsetDateTimeType;
import org.hibernate.type.OffsetTimeType;
import org.hibernate.type.RowVersionType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringNVarcharType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.UUIDBinaryType;
import org.hibernate.type.UUIDCharType;
import org.hibernate.type.UrlType;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.YesNoType;
import org.hibernate.type.ZoneOffsetType;
import org.hibernate.type.ZonedDateTimeType;
import org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveCharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.NClobTypeDescriptor;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public final class StandardBasicTypes {
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final NumericBooleanType NUMERIC_BOOLEAN = NumericBooleanType.INSTANCE;
    public static final TrueFalseType TRUE_FALSE = TrueFalseType.INSTANCE;
    public static final YesNoType YES_NO = YesNoType.INSTANCE;
    public static final ByteType BYTE = ByteType.INSTANCE;
    public static final ShortType SHORT = ShortType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final BigIntegerType BIG_INTEGER = BigIntegerType.INSTANCE;
    public static final BigDecimalType BIG_DECIMAL = BigDecimalType.INSTANCE;
    public static final CharacterType CHARACTER = CharacterType.INSTANCE;
    public static final CharacterNCharType CHARACTER_NCHAR = CharacterNCharType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final StringNVarcharType NSTRING = StringNVarcharType.INSTANCE;
    public static final CharArrayType CHAR_ARRAY = CharArrayType.INSTANCE;
    public static final CharacterArrayType CHARACTER_ARRAY = CharacterArrayType.INSTANCE;
    public static final TextType TEXT = TextType.INSTANCE;
    public static final NTextType NTEXT = NTextType.INSTANCE;
    public static final ClobType CLOB = ClobType.INSTANCE;
    public static final NClobType NCLOB = NClobType.INSTANCE;
    public static final MaterializedClobType MATERIALIZED_CLOB = MaterializedClobType.INSTANCE;
    public static final MaterializedNClobType MATERIALIZED_NCLOB = MaterializedNClobType.INSTANCE;
    public static final StandardBasicTypeImpl<String> MATERIALIZED_CLOB_CHAR_ARRAY = new StandardBasicTypeImpl<char[]>(PrimitiveCharacterArrayTypeDescriptor.INSTANCE, ClobTypeDescriptor.CLOB_BINDING);
    public static final StandardBasicTypeImpl<String> MATERIALIZED_CLOB_CHARACTER_ARRAY = new StandardBasicTypeImpl<Character[]>(CharacterArrayTypeDescriptor.INSTANCE, ClobTypeDescriptor.CLOB_BINDING);
    public static final StandardBasicTypeImpl<String> MATERIALIZED_NCLOB_CHAR_ARRAY = new StandardBasicTypeImpl<char[]>(PrimitiveCharacterArrayTypeDescriptor.INSTANCE, NClobTypeDescriptor.NCLOB_BINDING);
    public static final StandardBasicTypeImpl<Character[]> MATERIALIZED_NCLOB_CHARACTER_ARRAY = new StandardBasicTypeImpl<Character[]>(CharacterArrayTypeDescriptor.INSTANCE, NClobTypeDescriptor.NCLOB_BINDING);
    public static final DurationType DURATION = DurationType.INSTANCE;
    public static final LocalDateTimeType LOCAL_DATE_TIME = LocalDateTimeType.INSTANCE;
    public static final LocalDateType LOCAL_DATE = LocalDateType.INSTANCE;
    public static final LocalTimeType LOCAL_TIME = LocalTimeType.INSTANCE;
    public static final OffsetDateTimeType OFFSET_DATE_TIME = OffsetDateTimeType.INSTANCE;
    public static final OffsetTimeType OFFSET_TIME = OffsetTimeType.INSTANCE;
    public static final ZonedDateTimeType ZONED_DATE_TIME = ZonedDateTimeType.INSTANCE;
    public static final InstantType INSTANT = InstantType.INSTANCE;
    public static final TimeType TIME = TimeType.INSTANCE;
    public static final DateType DATE = DateType.INSTANCE;
    public static final TimestampType TIMESTAMP = TimestampType.INSTANCE;
    public static final CalendarType CALENDAR = CalendarType.INSTANCE;
    public static final CalendarDateType CALENDAR_DATE = CalendarDateType.INSTANCE;
    public static final CalendarTimeType CALENDAR_TIME = CalendarTimeType.INSTANCE;
    public static final BinaryType BINARY = BinaryType.INSTANCE;
    public static final WrapperBinaryType WRAPPER_BINARY = WrapperBinaryType.INSTANCE;
    public static final ImageType IMAGE = ImageType.INSTANCE;
    public static final BlobType BLOB = BlobType.INSTANCE;
    public static final MaterializedBlobType MATERIALIZED_BLOB = MaterializedBlobType.INSTANCE;
    public static final SerializableType SERIALIZABLE = SerializableType.INSTANCE;
    public static final JavaObjectType OBJECT_TYPE = JavaObjectType.INSTANCE;
    public static final ClassType CLASS = ClassType.INSTANCE;
    public static final LocaleType LOCALE = LocaleType.INSTANCE;
    public static final CurrencyType CURRENCY = CurrencyType.INSTANCE;
    public static final ZoneOffsetType ZONE_OFFSET = ZoneOffsetType.INSTANCE;
    public static final TimeZoneType TIMEZONE = TimeZoneType.INSTANCE;
    public static final UrlType URL = UrlType.INSTANCE;
    public static final UUIDBinaryType UUID_BINARY = UUIDBinaryType.INSTANCE;
    public static final UUIDCharType UUID_CHAR = UUIDCharType.INSTANCE;
    public static final RowVersionType ROW_VERSION = RowVersionType.INSTANCE;

    private StandardBasicTypes() {
    }

    public static void prime(TypeConfiguration typeConfiguration) {
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        if (basicTypeRegistry.isPrimed()) {
            return;
        }
        StandardBasicTypes.handle(BOOLEAN, "org.hibernate.type.BooleanType", basicTypeRegistry, "boolean", Boolean.TYPE.getName(), Boolean.class.getName());
        StandardBasicTypes.handle(NUMERIC_BOOLEAN, "org.hibernate.type.NumericBooleanType", basicTypeRegistry, "numeric_boolean");
        StandardBasicTypes.handle(TRUE_FALSE, "org.hibernate.type.TrueFalseType", basicTypeRegistry, "true_false");
        StandardBasicTypes.handle(YES_NO, "org.hibernate.type.YesNoType", basicTypeRegistry, "yes_no");
        StandardBasicTypes.handle(BYTE, "org.hibernate.type.ByteType", basicTypeRegistry, "byte", Byte.TYPE.getName(), Byte.class.getName());
        StandardBasicTypes.handle(BINARY, "org.hibernate.type.BinaryType", basicTypeRegistry, "binary", "byte[]", byte[].class.getName());
        StandardBasicTypes.handle(WRAPPER_BINARY, "org.hibernate.type.WrapperBinaryType", basicTypeRegistry, "wrapper-binary", "Byte[]", Byte[].class.getName());
        StandardBasicTypes.handle(IMAGE, "org.hibernate.type.ImageType", basicTypeRegistry, "image");
        StandardBasicTypes.handle(BLOB, "org.hibernate.type.BlobType", basicTypeRegistry, "blob", Blob.class.getName());
        StandardBasicTypes.handle(MATERIALIZED_BLOB, "org.hibernate.type.MaterializedBlobType", basicTypeRegistry, "materialized_blob");
        StandardBasicTypes.handle(WrappedMaterializedBlobType.INSTANCE, "org.hibernate.type.MaterializedBlobType", basicTypeRegistry, "wrapped_materialized_blob");
        StandardBasicTypes.handle(SHORT, "org.hibernate.type.ShortType", basicTypeRegistry, "short", Short.TYPE.getName(), Short.class.getName());
        StandardBasicTypes.handle(INTEGER, "org.hibernate.type.IntegerType", basicTypeRegistry, "integer", Integer.TYPE.getName(), Integer.class.getName());
        StandardBasicTypes.handle(LONG, "org.hibernate.type.LongType", basicTypeRegistry, "long", Long.TYPE.getName(), Long.class.getName());
        StandardBasicTypes.handle(FLOAT, "org.hibernate.type.FloatType", basicTypeRegistry, "float", Float.TYPE.getName(), Float.class.getName());
        StandardBasicTypes.handle(DOUBLE, "org.hibernate.type.DoubleType", basicTypeRegistry, "double", Double.TYPE.getName(), Double.class.getName());
        StandardBasicTypes.handle(BIG_INTEGER, "org.hibernate.type.BigIntegerType", basicTypeRegistry, "big_integer", BigInteger.class.getName());
        StandardBasicTypes.handle(BIG_DECIMAL, "org.hibernate.type.BigDecimalType", basicTypeRegistry, "big_decimal", BigDecimal.class.getName());
        StandardBasicTypes.handle(CHARACTER, "org.hibernate.type.CharacterType", basicTypeRegistry, "character", Character.TYPE.getName(), Character.class.getName());
        StandardBasicTypes.handle(CHARACTER_NCHAR, null, basicTypeRegistry, "character_nchar");
        StandardBasicTypes.handle(STRING, "org.hibernate.type.StringType", basicTypeRegistry, "string", String.class.getName());
        StandardBasicTypes.handle(NSTRING, "org.hibernate.type.StringNVarcharType", basicTypeRegistry, "nstring");
        StandardBasicTypes.handle(CHAR_ARRAY, "org.hibernate.type.CharArrayType", basicTypeRegistry, "characters", "char[]", char[].class.getName());
        StandardBasicTypes.handle(CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayType", basicTypeRegistry, "wrapper-characters", Character[].class.getName(), "Character[]");
        StandardBasicTypes.handle(TEXT, "org.hibernate.type.TextType", basicTypeRegistry, "text");
        StandardBasicTypes.handle(NTEXT, "org.hibernate.type.NTextType", basicTypeRegistry, "ntext");
        StandardBasicTypes.handle(CLOB, "org.hibernate.type.ClobType", basicTypeRegistry, "clob", Clob.class.getName());
        StandardBasicTypes.handle(NCLOB, "org.hibernate.type.NClobType", basicTypeRegistry, "nclob", NClob.class.getName());
        StandardBasicTypes.handle(MATERIALIZED_CLOB, "org.hibernate.type.MaterializedClobType", basicTypeRegistry, "materialized_clob");
        StandardBasicTypes.handle(MATERIALIZED_CLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayClobType", basicTypeRegistry, "materialized_clob_char_array");
        StandardBasicTypes.handle(MATERIALIZED_CLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayClobType", basicTypeRegistry, "materialized_clob_character_array");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB, "org.hibernate.type.MaterializedNClobType", basicTypeRegistry, "materialized_nclob");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayNClobType", basicTypeRegistry, "materialized_nclob_character_array");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayNClobType", basicTypeRegistry, "materialized_nclob_char_array");
        StandardBasicTypes.handle(DURATION, "org.hibernate.type.DurationType", basicTypeRegistry, Duration.class.getSimpleName(), Duration.class.getName());
        StandardBasicTypes.handle(LOCAL_DATE_TIME, "org.hibernate.type.LocalDateTimeType", basicTypeRegistry, LocalDateTime.class.getSimpleName(), LocalDateTime.class.getName());
        StandardBasicTypes.handle(LOCAL_DATE, "org.hibernate.type.LocalDateType", basicTypeRegistry, LocalDate.class.getSimpleName(), LocalDate.class.getName());
        StandardBasicTypes.handle(LOCAL_TIME, "org.hibernate.type.LocalTimeType", basicTypeRegistry, LocalTime.class.getSimpleName(), LocalTime.class.getName());
        StandardBasicTypes.handle(OFFSET_DATE_TIME, "org.hibernate.type.OffsetDateTimeType", basicTypeRegistry, OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
        StandardBasicTypes.handle(OFFSET_TIME, "org.hibernate.type.OffsetTimeType", basicTypeRegistry, OffsetTime.class.getSimpleName(), OffsetTime.class.getName());
        StandardBasicTypes.handle(ZONED_DATE_TIME, "org.hibernate.type.ZonedDateTimeType", basicTypeRegistry, ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
        StandardBasicTypes.handle(DATE, "org.hibernate.type.DateType", basicTypeRegistry, "date", java.sql.Date.class.getName());
        StandardBasicTypes.handle(TIME, "org.hibernate.type.TimeType", basicTypeRegistry, "time", Time.class.getName());
        StandardBasicTypes.handle(TIMESTAMP, "org.hibernate.type.TimestampType", basicTypeRegistry, "timestamp", Timestamp.class.getName(), Date.class.getName());
        StandardBasicTypes.handle(CALENDAR, "org.hibernate.type.CalendarType", basicTypeRegistry, "calendar", Calendar.class.getName(), GregorianCalendar.class.getName());
        StandardBasicTypes.handle(CALENDAR_DATE, "org.hibernate.type.CalendarDateType", basicTypeRegistry, "calendar_date");
        StandardBasicTypes.handle(CALENDAR_TIME, "org.hibernate.type.CalendarTimeType", basicTypeRegistry, "calendar_date");
        StandardBasicTypes.handle(INSTANT, "org.hibernate.type.InstantType", basicTypeRegistry, "instant", Instant.class.getName());
        StandardBasicTypes.handle(UUID_BINARY, "org.hibernate.type.UUIDBinaryType", basicTypeRegistry, "uuid-binary", UUID.class.getName());
        StandardBasicTypes.handle(UUID_CHAR, "org.hibernate.type.UUIDCharType", basicTypeRegistry, "uuid-char");
        StandardBasicTypes.handle(CLASS, "org.hibernate.type.ClassType", basicTypeRegistry, "class", Class.class.getName());
        StandardBasicTypes.handle(CURRENCY, "org.hibernate.type.CurrencyType", basicTypeRegistry, "currency", Currency.class.getSimpleName(), Currency.class.getName());
        StandardBasicTypes.handle(LOCALE, "org.hibernate.type.LocaleType", basicTypeRegistry, "locale", Locale.class.getName());
        StandardBasicTypes.handle(SERIALIZABLE, "org.hibernate.type.SerializableType", basicTypeRegistry, "serializable", Serializable.class.getName());
        StandardBasicTypes.handle(TIMEZONE, "org.hibernate.type.TimeZoneType", basicTypeRegistry, "timezone", TimeZone.class.getName());
        StandardBasicTypes.handle(ZONE_OFFSET, "org.hibernate.type.ZoneOffsetType", basicTypeRegistry, ZoneOffset.class.getSimpleName(), ZoneOffset.class.getName());
        StandardBasicTypes.handle(URL, "org.hibernate.type.UrlType", basicTypeRegistry, "url", URL.class.getName());
        StandardBasicTypes.handle(ROW_VERSION, null, basicTypeRegistry, "row_version");
        StandardBasicTypes.handle(DbTimestampType.INSTANCE, null, basicTypeRegistry, DbTimestampType.INSTANCE.getName());
        basicTypeRegistry.primed();
    }

    private static void handle(BasicType type, String legacyTypeClassName, BasicTypeRegistry basicTypeRegistry, String ... registrationKeys) {
        basicTypeRegistry.addPrimeEntry(type, legacyTypeClassName, registrationKeys);
    }
}

