/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.DateType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.TimeType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampType
extends AbstractSingleColumnStandardBasicType<Date>
implements VersionType<Date>,
LiteralType<Date>,
AllowableTemporalParameterType<Date> {
    public static final TimestampType INSTANCE = new TimestampType();

    public TimestampType() {
        super(TimestampTypeDescriptor.INSTANCE, JdbcTimestampTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "timestamp";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Timestamp.class.getName(), Date.class.getName()};
    }

    @Override
    public Date next(Date current, SharedSessionContractImplementor session) {
        return this.seed(session);
    }

    @Override
    public Date seed(SharedSessionContractImplementor session) {
        return new Timestamp(System.currentTimeMillis());
    }

    @Override
    public Comparator<Date> getComparator() {
        return this.getJavaTypeDescriptor().getComparator();
    }

    @Override
    public Date fromStringValue(String xml) throws HibernateException {
        return (Date)this.fromString(xml);
    }

    @Override
    public AllowableTemporalParameterType resolveTemporalPrecision(TemporalType temporalPrecision, TypeConfiguration typeConfiguration) {
        switch (temporalPrecision) {
            case TIMESTAMP: {
                return this;
            }
            case DATE: {
                return DateType.INSTANCE;
            }
            case TIME: {
                return TimeType.INSTANCE;
            }
        }
        throw new QueryException("Timestamp type cannot be treated using `" + temporalPrecision.name() + "` precision");
    }
}

