/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.CastType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.StringType;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.CharTypeDescriptor;

public class YesNoType
extends AbstractSingleColumnStandardBasicType<Boolean>
implements PrimitiveType<Boolean>,
DiscriminatorType<Boolean>,
ConvertedBasicType<Boolean> {
    public static final YesNoType INSTANCE = new YesNoType();
    private static final YesNoConverter CONVERTER = new YesNoConverter();

    public YesNoType() {
        super(CharTypeDescriptor.INSTANCE, BooleanTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "yes_no";
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Boolean stringToObject(String xml) throws Exception {
        return (Boolean)this.fromString(xml);
    }

    @Override
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public String objectToSQLString(Boolean value, Dialect dialect) throws Exception {
        return StringType.INSTANCE.objectToSQLString(value != false ? "Y" : "N", dialect);
    }

    @Override
    public CastType getCastType() {
        return CastType.YN_BOOLEAN;
    }

    @Override
    public BasicValueConverter<Boolean, ?> getValueConverter() {
        return CONVERTER;
    }

    @Internal
    public static class YesNoConverter
    implements BasicValueConverter<Boolean, Character> {
        public static final YesNoConverter INSTANCE = new YesNoConverter();

        @Override
        public Boolean toDomainValue(Character relationalForm) {
            return YesNoConverter.toDomain(relationalForm);
        }

        public static Boolean toDomain(Character relationalForm) {
            if (relationalForm == null) {
                return null;
            }
            if ('Y' == relationalForm.charValue()) {
                return true;
            }
            if ('N' == relationalForm.charValue()) {
                return false;
            }
            return null;
        }

        @Override
        public Character toRelationalValue(Boolean domainForm) {
            return YesNoConverter.toRelational(domainForm);
        }

        public static Character toRelational(Boolean domainForm) {
            if (domainForm == null) {
                return null;
            }
            return Character.valueOf(domainForm != false ? (char)'Y' : 'N');
        }

        @Override
        public JavaTypeDescriptor<Boolean> getDomainJavaDescriptor() {
            return BooleanTypeDescriptor.INSTANCE;
        }

        @Override
        public JavaTypeDescriptor<Character> getRelationalJavaDescriptor() {
            return CharacterTypeDescriptor.INSTANCE;
        }
    }
}

