/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.DateTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.TimeTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TimestampWithTimeZoneDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class ZonedDateTimeJavaDescriptor
extends AbstractTemporalTypeDescriptor<ZonedDateTime> {
    public static final ZonedDateTimeJavaDescriptor INSTANCE = new ZonedDateTimeJavaDescriptor();

    public ZonedDateTimeJavaDescriptor() {
        super(ZonedDateTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcTypeDescriptor getRecommendedJdbcType(JdbcTypeDescriptorIndicators stdIndicators) {
        TemporalType temporalPrecision = stdIndicators.getTemporalPrecision();
        if (temporalPrecision == null || temporalPrecision == TemporalType.TIMESTAMP) {
            return TimestampWithTimeZoneDescriptor.INSTANCE;
        }
        switch (temporalPrecision) {
            case TIME: {
                return TimeTypeDescriptor.INSTANCE;
            }
            case DATE: {
                return DateTypeDescriptor.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unexpected javax.persistence.TemporalType : " + temporalPrecision);
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(ZonedDateTime value) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value);
    }

    @Override
    public ZonedDateTime fromString(String string) {
        return ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(ZonedDateTime zonedDateTime, Class<X> type, WrapperOptions options) {
        if (zonedDateTime == null) {
            return null;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)zonedDateTime;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            if (zonedDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            }
            return (X)Timestamp.from(zonedDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(zonedDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(zonedDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(zonedDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(zonedDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZonedDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (ZonedDateTime.class.isInstance(value)) {
            return (ZonedDateTime)value;
        }
        if (OffsetDateTime.class.isInstance(value)) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return offsetDateTime.toZonedDateTime();
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault());
            }
            return ts.toInstant().atZone(ZoneId.systemDefault());
        }
        if (java.util.Date.class.isInstance(value)) {
            java.util.Date date = (java.util.Date)value;
            return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (Long.class.isInstance(value)) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }
}

