/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import javax.persistence.TemporalType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimeTypeDescriptor
implements JdbcTypeDescriptor {
    public static final TimeTypeDescriptor INSTANCE = new TimeTypeDescriptor();

    @Override
    public int getJdbcType() {
        return 92;
    }

    @Override
    public String getFriendlyName() {
        return "TIME";
    }

    public String toString() {
        return "TimeTypeDescriptor";
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
        return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Time.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return new JdbcLiteralFormatterTemporal(javaTypeDescriptor, TemporalType.TIME);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Time time = javaTypeDescriptor.unwrap(value, Time.class, options);
                if (value instanceof Calendar) {
                    st.setTime(index, time, (Calendar)value);
                } else if (options.getJdbcTimeZone() != null) {
                    st.setTime(index, time, Calendar.getInstance(options.getJdbcTimeZone()));
                } else {
                    st.setTime(index, time);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Time time = javaTypeDescriptor.unwrap(value, Time.class, options);
                if (value instanceof Calendar) {
                    st.setTime(name, time, (Calendar)value);
                } else if (options.getJdbcTimeZone() != null) {
                    st.setTime(name, time, Calendar.getInstance(options.getJdbcTimeZone()));
                } else {
                    st.setTime(name, time);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaTypeDescriptor.wrap(rs.getTime(paramIndex, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaTypeDescriptor.wrap(rs.getTime(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaTypeDescriptor.wrap(statement.getTime(index, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaTypeDescriptor.wrap(statement.getTime(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return options.getJdbcTimeZone() != null ? javaTypeDescriptor.wrap(statement.getTime(name, Calendar.getInstance(options.getJdbcTimeZone())), options) : javaTypeDescriptor.wrap(statement.getTime(name), options);
            }
        };
    }
}

