/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import javax.persistence.TemporalType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampWithTimeZoneDescriptor
implements JdbcTypeDescriptor {
    public static final TimestampWithTimeZoneDescriptor INSTANCE = new TimestampWithTimeZoneDescriptor();

    @Override
    public int getJdbcType() {
        return 2014;
    }

    @Override
    public String getFriendlyName() {
        return "TIMESTAMP_WITH_TIMEZONE";
    }

    public String toString() {
        return "TimestampWithTimeZoneDescriptor";
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
        return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)OffsetDateTime.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return new JdbcLiteralFormatterTemporal(javaTypeDescriptor, TemporalType.TIMESTAMP);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions wrapperOptions) throws SQLException {
                try {
                    OffsetDateTime dateTime = javaTypeDescriptor.unwrap(value, OffsetDateTime.class, wrapperOptions);
                    st.setObject(index, (Object)dateTime, 2014);
                }
                catch (AbstractMethodError | SQLException e) {
                    Timestamp timestamp = javaTypeDescriptor.unwrap(value, Timestamp.class, wrapperOptions);
                    st.setTimestamp(index, timestamp);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions wrapperOptions) throws SQLException {
                try {
                    OffsetDateTime dateTime = javaTypeDescriptor.unwrap(value, OffsetDateTime.class, wrapperOptions);
                    st.setObject(name, (Object)dateTime, 2014);
                }
                catch (AbstractMethodError | SQLException e) {
                    Timestamp timestamp = javaTypeDescriptor.unwrap(value, Timestamp.class, wrapperOptions);
                    st.setTimestamp(name, timestamp);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int position, WrapperOptions wrapperOptions) throws SQLException {
                try {
                    return javaTypeDescriptor.wrap(rs.getObject(position, OffsetDateTime.class), wrapperOptions);
                }
                catch (AbstractMethodError | SQLException e) {
                    return javaTypeDescriptor.wrap(rs.getTimestamp(position), wrapperOptions);
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, int position, WrapperOptions wrapperOptions) throws SQLException {
                try {
                    return javaTypeDescriptor.wrap(statement.getObject(position, OffsetDateTime.class), wrapperOptions);
                }
                catch (AbstractMethodError | SQLException e) {
                    return javaTypeDescriptor.wrap(statement.getTimestamp(position), wrapperOptions);
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions wrapperOptions) throws SQLException {
                try {
                    return javaTypeDescriptor.wrap(statement.getObject(name, OffsetDateTime.class), wrapperOptions);
                }
                catch (AbstractMethodError | SQLException e) {
                    return javaTypeDescriptor.wrap(statement.getTimestamp(name), wrapperOptions);
                }
            }
        };
    }
}

