/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import java.sql.Time;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterTemporal
extends BasicJdbcLiteralFormatter {
    private final TemporalType precision;

    public JdbcLiteralFormatterTemporal(JavaTypeDescriptor javaTypeDescriptor, TemporalType precision) {
        super(javaTypeDescriptor);
        this.precision = precision;
    }

    public String toJdbcLiteral(Object value, Dialect dialect, WrapperOptions wrapperOptions) {
        TimeZone jdbcTimeZone = wrapperOptions == null || wrapperOptions.getJdbcTimeZone() == null ? TimeZone.getDefault() : wrapperOptions.getJdbcTimeZone();
        if (value instanceof Date) {
            return dialect.formatDateTimeLiteral((Date)value, this.precision, jdbcTimeZone);
        }
        if (value instanceof Calendar) {
            return dialect.formatDateTimeLiteral((Calendar)value, this.precision, jdbcTimeZone);
        }
        if (value instanceof TemporalAccessor) {
            return dialect.formatDateTimeLiteral((TemporalAccessor)value, this.precision, jdbcTimeZone);
        }
        switch (this.precision) {
            case DATE: {
                return dialect.formatDateTimeLiteral(this.unwrap(value, java.sql.Date.class, wrapperOptions), this.precision, jdbcTimeZone);
            }
            case TIME: {
                return dialect.formatDateTimeLiteral(this.unwrap(value, Time.class, wrapperOptions), this.precision, jdbcTimeZone);
            }
        }
        return dialect.formatDateTimeLiteral(this.unwrap(value, Date.class, wrapperOptions), this.precision, jdbcTimeZone);
    }
}

