/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.metamodel.model.domain.AllowableTemporalParameterType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.SerializableTypeDescriptor;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TinyIntTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static BasicValue.Resolution from(Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess, Function<TypeConfiguration, JdbcTypeDescriptor> explicitSqlTypeAccess, Type resolvedJavaType, Supplier<JavaTypeDescriptor> reflectedJtdResolver, JdbcTypeDescriptorIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, TypeConfiguration typeConfiguration) {
        BasicType<Object> legacyType;
        BasicType<Object> jdbcMapping;
        BasicJavaDescriptor explicitJavaType = explicitJavaTypeAccess != null ? explicitJavaTypeAccess.apply(typeConfiguration) : null;
        JdbcTypeDescriptor explicitJdbcType = explicitSqlTypeAccess != null ? explicitSqlTypeAccess.apply(typeConfiguration) : null;
        BasicJavaDescriptor reflectedJtd = (BasicJavaDescriptor)reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, explicitJdbcType);
            } else {
                JdbcTypeDescriptor inferredJdbcType = explicitJavaType.getRecommendedJdbcType(stdIndicators);
                if (inferredJdbcType instanceof ObjectJdbcTypeDescriptor) {
                    if (explicitJavaType instanceof EnumJavaTypeDescriptor) {
                        return InferredBasicValueResolver.fromEnum((EnumJavaTypeDescriptor)reflectedJtd, explicitJavaType, null, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof TemporalJavaTypeDescriptor) {
                        return InferredBasicValueResolver.fromTemporal((TemporalJavaTypeDescriptor)reflectedJtd, explicitJavaType, null, resolvedJavaType, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof SerializableTypeDescriptor || explicitJavaType.getJavaType() instanceof Serializable) {
                        jdbcMapping = legacyType = new SerializableType(explicitJavaType);
                    } else {
                        legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                    }
                } else {
                    legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                }
            }
        } else if (reflectedJtd != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, explicitJdbcType);
            } else {
                if (reflectedJtd instanceof EnumJavaTypeDescriptor) {
                    return InferredBasicValueResolver.fromEnum((EnumJavaTypeDescriptor)reflectedJtd, null, null, stdIndicators, typeConfiguration);
                }
                if (reflectedJtd instanceof TemporalJavaTypeDescriptor) {
                    return InferredBasicValueResolver.fromTemporal((TemporalJavaTypeDescriptor)reflectedJtd, null, null, resolvedJavaType, stdIndicators, typeConfiguration);
                }
                BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
                if (registeredType != null) {
                    jdbcMapping = legacyType = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType, reflectedJtd);
                } else if (reflectedJtd instanceof SerializableTypeDescriptor || reflectedJtd.getJavaType() instanceof Serializable) {
                    jdbcMapping = legacyType = new SerializableType(reflectedJtd);
                } else {
                    legacyType = null;
                    jdbcMapping = null;
                }
            }
        } else if (explicitJdbcType != null) {
            BasicJavaDescriptor recommendedJtd = explicitJdbcType.getJdbcRecommendedJavaTypeMapping(typeConfiguration);
            BasicType resolved = typeConfiguration.getBasicTypeRegistry().resolve(recommendedJtd, explicitJdbcType);
            legacyType = jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, resolved, recommendedJtd);
        } else {
            throw new MappingException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        if (jdbcMapping == null) {
            throw new MappingException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use for " + ((BasicValue)stdIndicators).getResolvedJavaType() + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJdbcTypeDescriptor(), null, legacyType, null);
    }

    public static BasicType<?> resolveSqlTypeIndicators(JdbcTypeDescriptorIndicators stdIndicators, BasicType<?> resolved, JavaTypeDescriptor<?> domainJtd) {
        if (resolved instanceof AdjustableBasicType) {
            AdjustableBasicType indicatorCapable = (AdjustableBasicType)resolved;
            BasicType<?> indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators, domainJtd);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static InferredBasicValueResolution fromEnum(EnumJavaTypeDescriptor enumJavaDescriptor, BasicJavaDescriptor explicitJavaType, JdbcTypeDescriptor explicitJdbcType, JdbcTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        EnumType enumStyle = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : EnumType.ORDINAL;
        switch (enumStyle) {
            case STRING: {
                JavaTypeDescriptor relationalJtd;
                if (explicitJavaType != null) {
                    if (!String.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#STRING should handle `java.lang.String` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    boolean useCharacter = stdIndicators.getColumnLength() == 1L;
                    Class relationalJavaType = useCharacter ? Character.class : String.class;
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)relationalJavaType));
                }
                JdbcTypeDescriptor jdbcTypeDescriptor = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(stdIndicators);
                NamedEnumValueConverter valueConverter = new NamedEnumValueConverter(enumJavaDescriptor, jdbcTypeDescriptor, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaTypeClass(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcTypeDescriptor);
                return new InferredBasicValueResolution(jdbcMapping, enumJavaDescriptor, relationalJtd, jdbcTypeDescriptor, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
            case ORDINAL: {
                BasicJavaDescriptor relationalJtd;
                if (explicitJavaType != null) {
                    if (!Integer.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#ORDINAL should handle `java.lang.Integer` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class));
                }
                JdbcTypeDescriptor jdbcTypeDescriptor = explicitJdbcType != null ? explicitJdbcType : TinyIntTypeDescriptor.INSTANCE;
                OrdinalEnumValueConverter valueConverter = new OrdinalEnumValueConverter(enumJavaDescriptor, jdbcTypeDescriptor, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaTypeClass(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcTypeDescriptor);
                return new InferredBasicValueResolution(jdbcMapping, enumJavaDescriptor, relationalJtd, jdbcTypeDescriptor, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
        }
        throw new MappingException("Unknown enumeration-style (JPA EnumType) : " + enumStyle);
    }

    public static InferredBasicValueResolution fromTemporal(TemporalJavaTypeDescriptor reflectedJtd, BasicJavaDescriptor explicitJavaType, JdbcTypeDescriptor explicitJdbcType, Type resolvedJavaType, JdbcTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!TemporalJavaTypeDescriptor.class.isInstance(explicitJavaType)) {
                throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] defined for temporal value must implement TemporalJavaTypeDescriptor");
            }
            TemporalJavaTypeDescriptor explicitTemporalJtd = (TemporalJavaTypeDescriptor)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`javax.persistence.TemporalType`) mismatch... requested precision = " + requestedTemporalPrecision + "; explicit JavaTypeDescriptor (`" + explicitTemporalJtd + "`) precision = " + explicitTemporalJtd.getPrecision());
            }
            JdbcTypeDescriptor jdbcTypeDescriptor = explicitJdbcType != null ? explicitJdbcType : explicitTemporalJtd.getRecommendedJdbcType(stdIndicators);
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitTemporalJtd, jdbcTypeDescriptor);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, jdbcTypeDescriptor, null, jdbcMapping, explicitJavaType.getMutabilityPlan());
        }
        if (explicitJdbcType != null) {
            TemporalJavaTypeDescriptor jtd = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd;
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(jtd, explicitJdbcType);
            return new InferredBasicValueResolution(jdbcMapping, jtd, jtd, explicitJdbcType, null, jdbcMapping, jtd.getMutabilityPlan());
        }
        Type javaType = resolvedJavaType == null ? reflectedJtd.getJavaType() : resolvedJavaType;
        BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(javaType);
        AllowableTemporalParameterType legacyTemporalType = (AllowableTemporalParameterType)((Object)registeredType);
        BasicType basicType = requestedTemporalPrecision != null ? (BasicType)((Object)legacyTemporalType.resolveTemporalPrecision(requestedTemporalPrecision, typeConfiguration)) : registeredType;
        return new InferredBasicValueResolution(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getJdbcTypeDescriptor(), null, basicType, reflectedJtd.getMutabilityPlan());
    }
}

