/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.internal.NamedNativeQueryDefinitionImpl;
import org.hibernate.boot.query.AbstractNamedQueryBuilder;
import org.hibernate.boot.query.NamedNativeQueryDefinition;

public class NamedNativeQueryDefinitionBuilder
extends AbstractNamedQueryBuilder<NamedNativeQueryDefinitionBuilder> {
    private String sqlString;
    private String resultSetMappingName;
    private String resultSetMappingClassName;
    private Set<String> querySpaces;
    private Map<String, String> parameterTypes;

    public NamedNativeQueryDefinitionBuilder(String name) {
        super(name);
    }

    public NamedNativeQueryDefinitionBuilder setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this.getThis();
    }

    public NamedNativeQueryDefinition build() {
        return new NamedNativeQueryDefinitionImpl(this.getName(), this.sqlString, this.resultSetMappingName, this.resultSetMappingClassName, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    @Override
    protected NamedNativeQueryDefinitionBuilder getThis() {
        return this;
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public NamedNativeQueryDefinitionBuilder addSynchronizedQuerySpaces(Set<String> querySpaces) {
        if (querySpaces == null || querySpaces.isEmpty()) {
            return this;
        }
        if (this.querySpaces == null) {
            this.querySpaces = new HashSet<String>();
        }
        this.querySpaces.addAll(querySpaces);
        return this.getThis();
    }

    public NamedNativeQueryDefinitionBuilder addSynchronizedQuerySpace(String space) {
        if (this.querySpaces == null) {
            this.querySpaces = new HashSet<String>();
        }
        this.querySpaces.add(space);
        return this.getThis();
    }

    public NamedNativeQueryDefinitionBuilder setQuerySpaces(Set<String> spaces) {
        this.querySpaces = spaces;
        return this;
    }

    public NamedNativeQueryDefinitionBuilder setResultSetMappingName(String resultSetMappingName) {
        this.resultSetMappingName = resultSetMappingName;
        return this;
    }

    public NamedNativeQueryDefinitionBuilder setResultSetMappingClassName(String resultSetMappingClassName) {
        this.resultSetMappingClassName = resultSetMappingClassName;
        return this;
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setFetchSize(Integer fetchSize) {
        return (NamedNativeQueryDefinitionBuilder)super.setFetchSize(fetchSize);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setCacheable(Boolean cacheable) {
        return (NamedNativeQueryDefinitionBuilder)super.setCacheable(cacheable);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setCacheRegion(String cacheRegion) {
        return (NamedNativeQueryDefinitionBuilder)super.setCacheRegion(cacheRegion);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setCacheMode(CacheMode cacheMode) {
        return (NamedNativeQueryDefinitionBuilder)super.setCacheMode(cacheMode);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setLockOptions(LockOptions lockOptions) {
        return (NamedNativeQueryDefinitionBuilder)super.setLockOptions(lockOptions);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setTimeout(Integer timeout) {
        return (NamedNativeQueryDefinitionBuilder)super.setTimeout(timeout);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setFlushMode(FlushMode flushMode) {
        return (NamedNativeQueryDefinitionBuilder)super.setFlushMode(flushMode);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setReadOnly(Boolean readOnly) {
        return (NamedNativeQueryDefinitionBuilder)super.setReadOnly(readOnly);
    }

    @Override
    public NamedNativeQueryDefinitionBuilder setComment(String comment) {
        return (NamedNativeQueryDefinitionBuilder)super.setComment(comment);
    }

    public void addParameterTypeHint(String name, String type) {
        if (this.parameterTypes == null) {
            this.parameterTypes = new HashMap<String, String>();
        }
        this.parameterTypes.put(name, type);
    }
}

