/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.BasicCollectionPersister;

public class PersistentSortedSet<E>
extends PersistentSet<E>
implements SortedSet<E> {
    protected Comparator<? super E> comparator;

    public PersistentSortedSet() {
    }

    public PersistentSortedSet(SharedSessionContractImplementor session, Comparator<E> comparator) {
        super(session);
        this.comparator = comparator;
    }

    @Deprecated
    public PersistentSortedSet(SessionImplementor session) {
        this((SharedSessionContractImplementor)session, (Comparator)null);
    }

    public PersistentSortedSet(SharedSessionContractImplementor session, SortedSet<E> set) {
        super(session, set);
        this.comparator = set.comparator();
    }

    @Deprecated
    public PersistentSortedSet(SessionImplementor session, SortedSet<E> set) {
        this((SharedSessionContractImplementor)session, set);
    }

    protected Serializable snapshot(BasicCollectionPersister persister, EntityMode entityMode) throws HibernateException {
        TreeMap<E, Object> clonedSet = new TreeMap<E, Object>(this.comparator);
        for (Object setElement : this.set) {
            Object copy = persister.getElementType().deepCopy(setElement, persister.getFactory());
            clonedSet.put(copy, copy);
        }
        return clonedSet;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        this.read();
        SortedSet<E> subSet = ((SortedSet)this.set).subSet(fromElement, toElement);
        return new SubSetProxy(subSet);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        this.read();
        SortedSet<E> headSet = ((SortedSet)this.set).headSet(toElement);
        return new SubSetProxy(headSet);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        this.read();
        SortedSet<E> tailSet = ((SortedSet)this.set).tailSet(fromElement);
        return new SubSetProxy(tailSet);
    }

    @Override
    public E first() {
        this.read();
        return ((SortedSet)this.set).first();
    }

    @Override
    public E last() {
        this.read();
        return ((SortedSet)this.set).last();
    }

    class SubSetProxy
    extends AbstractPersistentCollection.SetProxy<E>
    implements SortedSet<E> {
        SubSetProxy(SortedSet<E> s) {
            super(s);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.set).comparator();
        }

        @Override
        public E first() {
            return ((SortedSet)this.set).first();
        }

        @Override
        public SortedSet<E> headSet(E toValue) {
            return new SubSetProxy(((SortedSet)this.set).headSet(toValue));
        }

        @Override
        public E last() {
            return ((SortedSet)this.set).last();
        }

        @Override
        public SortedSet<E> subSet(E fromValue, E toValue) {
            return new SubSetProxy(((SortedSet)this.set).subSet(fromValue, toValue));
        }

        @Override
        public SortedSet<E> tailSet(E fromValue) {
            return new SubSetProxy(((SortedSet)this.set).tailSet(fromValue));
        }
    }
}

