/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.ListInitializerProducer;

public class StandardListSemantics<E>
implements CollectionSemantics<List<E>, E> {
    public static final StandardListSemantics<?> INSTANCE = new StandardListSemantics();

    private StandardListSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.LIST;
    }

    @Override
    public Class<List> getCollectionJavaType() {
        return List.class;
    }

    @Override
    public List<E> instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        return CollectionHelper.arrayList(anticipatedSize);
    }

    @Override
    public Iterator<E> getElementIterator(List<E> rawCollection) {
        return rawCollection.iterator();
    }

    @Override
    public void visitElements(List<E> rawCollection, Consumer<? super E> action) {
        rawCollection.forEach(action);
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return new ListInitializerProducer(attributeMapping, fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState), fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState));
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, Fetch indexFetch, Fetch elementFetch, DomainResultCreationState creationState) {
        if (indexFetch == null) {
            indexFetch = fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        if (elementFetch == null) {
            elementFetch = fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        return new ListInitializerProducer(attributeMapping, indexFetch, elementFetch);
    }

    @Override
    public PersistentCollection<E> instantiateWrapper(Object key, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentList(session);
    }

    @Override
    public PersistentCollection<E> wrap(List<E> rawCollection, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentList<E>(session, rawCollection);
    }
}

