/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import javax.persistence.TemporalType;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2zSqlAstTranslator;
import org.hibernate.dialect.identity.DB2390IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2zSequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.TemporalUnit;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2zDialect
extends DB2Dialect {
    private final int version;

    public DB2zDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public DB2zDialect() {
        this(700);
    }

    public DB2zDialect(int version) {
        this.version = version;
        if (version > 1000) {
            this.registerColumnType(2014, "timestamp with time zone");
        }
    }

    @Override
    public boolean supportsTimezoneTypes() {
        return this.getZVersion() > 1000;
    }

    int getZVersion() {
        return this.version;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getZVersion() < 800 ? NoSequenceSupport.INSTANCE : DB2zSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getZVersion() < 800 ? null : "select * from sysibm.syssequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return FetchLimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2390IdentityColumnSupport();
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castTo = unit.isDateUnit() ? temporalType == TemporalType.TIME : temporalType == TemporalType.DATE;
        pattern.append("add_");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("s(");
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(",");
        switch (unit) {
            case NANOSECOND: {
                pattern.append("(?2)/1e9");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3");
                break;
            }
            default: {
                pattern.append("?2");
            }
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2zSqlAstTranslator(sessionFactory, statement, DB2zDialect.this.version);
            }
        };
    }
}

