/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class HSQLSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public HSQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        if (this.getDialect().getVersion() < 200) {
            return AbstractSqlAstTranslator.LockStrategy.NONE;
        }
        return super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
    }

    @Override
    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
        if (this.getDialect().getVersion() < 200) {
            return;
        }
        super.renderForUpdateClause(querySpec, forUpdateClause);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause()) {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        switch (operator) {
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                this.render(lhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                this.appendSql(" ");
                this.appendSql(operator.sqlText());
                this.appendSql(" ");
                this.render(rhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                break;
            }
            default: {
                this.renderComparisonStandard(lhs, operator, rhs);
            }
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from (values(0))";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 250;
    }
}

